/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sorter;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smartparam.engine.core.output.MultiValue;
import org.smartparam.engine.core.output.ParamValue;
import org.smartparam.engine.core.output.ParamValueImpl;
import org.smartparam.engine.core.type.ValueHolder;
import pl.decerto.hyperon.runtime.sorter.SortColumn;
import pl.decerto.hyperon.runtime.sorter.SortConfig;
import pl.decerto.hyperon.runtime.sorter.SortOrder;
import pl.decerto.hyperon.runtime.sorter.comparator.AlphanumericComparator;
import pl.decerto.hyperon.runtime.sorter.comparator.LocaleComparator;
import pl.decerto.hyperon.runtime.sorter.comparator.MatrixCellComparator;
import pl.decerto.hyperon.runtime.sorter.comparator.StandardComparator;

public class ParamSorter {
    private static final MatrixCellComparator STANDARD_COMPARATOR = new StandardComparator(false);
    private static final MatrixCellComparator STANDARD_COMPARATOR_IGNORECASE = new StandardComparator(true);
    private static final MatrixCellComparator ALPHANUMERIC_COMPARATOR = new AlphanumericComparator();
    private static final Map<String, MatrixCellComparator> localeComparatorCache = new ConcurrentHashMap<String, MatrixCellComparator>();

    public ParamValue sort(ParamValue matrix, SortConfig sort) {
        List<MultiValue> list = matrix.rows();
        MultiValue[] rows = list.toArray(new MultiValue[0]);
        ChainComparator comparator = new ChainComparator(sort);
        Arrays.sort(rows, comparator);
        return new ParamValueImpl(rows, matrix.getMetadata());
    }

    private static Comparator<ValueHolder> getLocaleComparator(String lang) {
        return localeComparatorCache.computeIfAbsent(lang, LocaleComparator::new);
    }

    static final class ChainComparator
    implements Comparator<MultiValue> {
        private SortConfig config;

        ChainComparator(SortConfig config) {
            this.config = config;
        }

        @Override
        public int compare(MultiValue o1, MultiValue o2) {
            for (SortColumn column : this.config.getColumns()) {
                int result;
                ValueHolder v1 = o1.getHolder(column.getOutNo());
                ValueHolder v2 = o2.getHolder(column.getOutNo());
                if (column.isText()) {
                    result = ALPHANUMERIC_COMPARATOR.compare(v1, v2);
                } else if (column.getLocale() != null) {
                    Comparator<ValueHolder> comp = ParamSorter.getLocaleComparator(column.getLocale().getLanguage());
                    result = comp.compare(v1, v2);
                } else {
                    result = column.isIgnoreCase() ? STANDARD_COMPARATOR_IGNORECASE.compare(v1, v2) : STANDARD_COMPARATOR.compare(v1, v2);
                }
                if (result == 0) continue;
                return column.getOrder() == SortOrder.ASC ? result : -result;
            }
            return 0;
        }
    }
}

