/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.spring.boot.starter;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import pl.decerto.hyperon.common.external.CoreExternalDataSourceProvider;
import pl.decerto.hyperon.common.utils.PropertyProvider;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.core.HyperonEngineFactory;
import pl.decerto.hyperon.runtime.spring.boot.starter.HyperonRuntimeProperties;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;
import pl.decerto.hyperon.runtime.sql.dialect.DialectParser;

@Configuration
@ConditionalOnClass(value={HyperonEngine.class})
@ConditionalOnProperty(value={"higson.runtime.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={HyperonRuntimeProperties.class})
public class HyperonRuntimeAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HyperonEngine hyperonEngine(HyperonRuntimeProperties properties, @Qualifier(value="hyperonDataSource") DataSource dataSource, CoreExternalDataSourceProvider externalDataSourceProvider) {
        HyperonEngineFactory factory = new HyperonEngineFactory();
        factory.setDataSource(dataSource);
        factory.setDeveloperMode(properties.getRuntime().isDevModeEnabled());
        factory.setExternalDataSources(externalDataSourceProvider.getDataSourceMap());
        return factory.create();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource hyperonDataSource(HyperonRuntimeProperties properties, @Qualifier(value="hyperonDialectTemplate") DialectTemplate dialectTemplate) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setUsername(properties.getDatabase().getUsername());
        dataSource.setPassword(properties.getDatabase().getPassword());
        dataSource.setJdbcUrl(properties.getDatabase().getUrl());
        dataSource.setDriverClassName(dialectTemplate.getJdbcDriverClassName());
        return dataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public DialectTemplate hyperonDialectTemplate(HyperonRuntimeProperties properties) {
        DialectRegistry dialectRegistry = new DialectRegistry();
        dialectRegistry.setDialect(DialectParser.getDatabaseDialect(properties.getDatabase().getUrl()));
        return dialectRegistry.create();
    }

    @Bean
    @ConditionalOnMissingBean
    public CoreExternalDataSourceProvider externalDataSourceProvider(Environment environment2, @Qualifier(value="hyperonDataSource") DataSource dataSource) {
        PropertyProvider propertyProvider = new PropertyProvider(environment2);
        String externalSourcesNames = propertyProvider.getProperty("higson.runtime.external-datasource.sql.names");
        CoreExternalDataSourceProvider externalDataSourceProvider = new CoreExternalDataSourceProvider(externalSourcesNames, propertyProvider);
        externalDataSourceProvider.configure(dataSource);
        return externalDataSourceProvider;
    }
}

