/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.spring.boot.starter;

import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="higson")
public class HyperonRuntimeProperties
implements InitializingBean {
    private Database database = new Database();
    private Runtime runtime = new Runtime();

    @Override
    public void afterPropertiesSet() {
        Objects.requireNonNull(this.database.url, "higson.database.url cannot be null");
        Objects.requireNonNull(this.database.username, "higson.database.username cannot be null");
        Objects.requireNonNull(this.database.password, "higson.database.password cannot be null");
    }

    public Database getDatabase() {
        return this.database;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HyperonRuntimeProperties)) {
            return false;
        }
        HyperonRuntimeProperties other = (HyperonRuntimeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Database this$database = this.getDatabase();
        Database other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        Runtime this$runtime = this.getRuntime();
        Runtime other$runtime = other.getRuntime();
        return !(this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HyperonRuntimeProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Database $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        Runtime $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        return result;
    }

    public String toString() {
        return "HyperonRuntimeProperties(database=" + this.getDatabase() + ", runtime=" + this.getRuntime() + ")";
    }

    public static class Database {
        private String url;
        private String username;
        private String password;

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Database)) {
                return false;
            }
            Database other = (Database)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Database;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "HyperonRuntimeProperties.Database(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }

    public static class Runtime {
        private boolean enabled;
        private boolean devModeEnabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDevModeEnabled() {
            return this.devModeEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDevModeEnabled(boolean devModeEnabled) {
            this.devModeEnabled = devModeEnabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Runtime)) {
                return false;
            }
            Runtime other = (Runtime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            return this.isDevModeEnabled() == other.isDevModeEnabled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Runtime;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + (this.isDevModeEnabled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HyperonRuntimeProperties.Runtime(enabled=" + this.isEnabled() + ", devModeEnabled=" + this.isDevModeEnabled() + ")";
        }
    }
}

