/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.utils.hash;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import pl.decerto.hyperon.runtime.utils.hash.DigestAlgorithm;
import pl.decerto.hyperon.runtime.utils.hash.DigestAlgorithmPool;

public class HashUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] DEFAULT_SEPARATOR = HashUtils.bytes(":");
    private static final byte[] EMPTY_ARRAY = new byte[0];

    private HashUtils() {
        throw new UnsupportedOperationException("util class");
    }

    public static String hash(DigestAlgorithm algo, String separator, String[] tokens) {
        return HashUtils.hash(algo, HashUtils.bytes(separator), tokens);
    }

    public static String hash(String algo, String separator, String[] tokens) {
        return HashUtils.hash(algo, HashUtils.bytes(separator), tokens);
    }

    public static String sha1(String separator, String[] tokens) {
        return HashUtils.hash(DigestAlgorithm.SHA1, HashUtils.bytes(separator), tokens);
    }

    public static String sha256(String separator, String[] tokens) {
        return HashUtils.hash(DigestAlgorithm.SHA256, HashUtils.bytes(separator), tokens);
    }

    public static String md5(String separator, String[] tokens) {
        return HashUtils.hash(DigestAlgorithm.MD5, HashUtils.bytes(separator), tokens);
    }

    public static String hash(DigestAlgorithm algo, String[] tokens) {
        return HashUtils.hash(algo, DEFAULT_SEPARATOR, tokens);
    }

    public static String hash(String algo, String[] tokens) {
        return HashUtils.hash(algo, DEFAULT_SEPARATOR, tokens);
    }

    public static String sha1(String[] tokens) {
        return HashUtils.hash(DigestAlgorithm.SHA1, DEFAULT_SEPARATOR, tokens);
    }

    public static String sha256(String[] tokens) {
        return HashUtils.hash(DigestAlgorithm.SHA256, DEFAULT_SEPARATOR, tokens);
    }

    public static String md5(String[] tokens) {
        return HashUtils.hash(DigestAlgorithm.MD5, DEFAULT_SEPARATOR, tokens);
    }

    public static String hashText(String algo, String text) {
        MessageDigest digest = HashUtils.getDigest(algo);
        digest.update(HashUtils.bytes(text));
        return HashUtils.toHex(digest);
    }

    public static String hashText(DigestAlgorithm algo, String text) {
        return HashUtils.hashText(algo.code(), text);
    }

    private static String hash(String algo, byte[] separator, String[] tokens) {
        MessageDigest digest = HashUtils.getDigest(algo);
        for (String t : tokens) {
            digest.update(HashUtils.bytes(t));
            digest.update(separator);
        }
        return HashUtils.toHex(digest);
    }

    private static String hash(DigestAlgorithm algo, byte[] separator, String[] tokens) {
        return HashUtils.hash(algo.code(), separator, tokens);
    }

    private static MessageDigest getDigest(String algo) {
        MessageDigest digest = DigestAlgorithmPool.get(algo);
        digest.reset();
        return digest;
    }

    private static String toHex(MessageDigest digest) {
        byte[] hash = digest.digest();
        return HashUtils.encodeHex(hash);
    }

    static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static char[] encodeHex(byte[] data, boolean lowercase) {
        return HashUtils.encodeHex(data, lowercase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHex(byte[] data) {
        return new String(HashUtils.encodeHex(data, true));
    }

    private static byte[] bytes(String str) {
        if (str == null) {
            return EMPTY_ARRAY;
        }
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

