/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.version.system;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.version.system.SystemVersionCache;

public class SystemVersionCacheMapImpl
implements SystemVersionCache {
    private static final Logger log = LoggerFactory.getLogger(SystemVersionCacheMapImpl.class);
    private final Map<EffectiveVersionCacheKey, SortedSet<Integer>> cache = new ConcurrentHashMap<EffectiveVersionCacheKey, SortedSet<Integer>>();

    @Override
    public void put(String profileCode, SortedSet<Integer> versionIdsToOmit, SortedSet<Integer> effectiveVersionIds) {
        if (log.isDebugEnabled()) {
            log.debug("adding to effective versions cache version ids:{}, in profile:{} and versionIds to omi:{}", effectiveVersionIds, profileCode, versionIdsToOmit);
        }
        this.cache.put(new EffectiveVersionCacheKey(profileCode, versionIdsToOmit), effectiveVersionIds);
    }

    @Override
    public Optional<SortedSet<Integer>> get(String profileCode, SortedSet<Integer> versionIdsToOmit) {
        return Optional.ofNullable(this.getFromCache(profileCode, versionIdsToOmit));
    }

    private SortedSet<Integer> getFromCache(String profileCode, SortedSet<Integer> versionIdsToOmit) {
        if (log.isDebugEnabled()) {
            log.debug("searching in system version cache, profile code:{}, versionIds to omit:{}", (Object)profileCode, (Object)versionIdsToOmit);
        }
        SortedSet<Integer> systemVersionIds = this.cache.get(new EffectiveVersionCacheKey(profileCode, versionIdsToOmit));
        log.debug("cache hit:{}", (Object)Objects.nonNull(systemVersionIds));
        if (log.isTraceEnabled()) {
            log.trace("returned system version ids from cache:{}", (Object)systemVersionIds);
        }
        return systemVersionIds;
    }

    @Override
    public void invalidate(String profileCode) {
        log.debug("invalidating system version cache entries for profile code:{} (case insensitive)", (Object)profileCode);
        this.cache.entrySet().removeIf(entry -> StringUtils.equalsIgnoreCase(profileCode, ((EffectiveVersionCacheKey)entry.getKey()).getProfileCode()));
    }

    private class EffectiveVersionCacheKey {
        private final String profileCode;
        private final SortedSet<Integer> omittedVersionsId;

        private EffectiveVersionCacheKey(String profileCode, SortedSet<Integer> omittedVersionsId) {
            this.profileCode = StringUtils.upperCase(profileCode);
            this.omittedVersionsId = omittedVersionsId;
        }

        public String getProfileCode() {
            return this.profileCode;
        }

        public SortedSet<Integer> getOmittedVersionsId() {
            return this.omittedVersionsId;
        }

        public String toString() {
            return "SystemVersionCacheMapImpl.EffectiveVersionCacheKey(profileCode=" + this.getProfileCode() + ", omittedVersionsId=" + this.getOmittedVersionsId() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EffectiveVersionCacheKey)) {
                return false;
            }
            EffectiveVersionCacheKey other = (EffectiveVersionCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$profileCode = this.getProfileCode();
            String other$profileCode = other.getProfileCode();
            if (this$profileCode == null ? other$profileCode != null : !this$profileCode.equals(other$profileCode)) {
                return false;
            }
            SortedSet<Integer> this$omittedVersionsId = this.getOmittedVersionsId();
            SortedSet<Integer> other$omittedVersionsId = other.getOmittedVersionsId();
            return !(this$omittedVersionsId == null ? other$omittedVersionsId != null : !this$omittedVersionsId.equals(other$omittedVersionsId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EffectiveVersionCacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $profileCode = this.getProfileCode();
            result = result * 59 + ($profileCode == null ? 43 : $profileCode.hashCode());
            SortedSet<Integer> $omittedVersionsId = this.getOmittedVersionsId();
            result = result * 59 + ($omittedVersionsId == null ? 43 : $omittedVersionsId.hashCode());
            return result;
        }
    }
}

