/*
 * Decompiled with CFR 0.152.
 */
package eu.infomas.annotation;

import eu.infomas.annotation.ClassFileBuffer;
import eu.infomas.annotation.ClassFileIterator;
import eu.infomas.annotation.ResourceIterator;
import eu.infomas.annotation.VfsResourceIterator;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class AnnotationDetector {
    private static final boolean DEBUG = false;
    private static final int CP_UTF8 = 1;
    private static final int CP_INTEGER = 3;
    private static final int CP_FLOAT = 4;
    private static final int CP_LONG = 5;
    private static final int CP_DOUBLE = 6;
    private static final int CP_CLASS = 7;
    private static final int CP_STRING = 8;
    private static final int CP_REF_FIELD = 9;
    private static final int CP_REF_METHOD = 10;
    private static final int CP_REF_INTERFACE = 11;
    private static final int CP_NAME_AND_TYPE = 12;
    private static final int CP_METHOD_HANDLE = 15;
    private static final int CP_METHOD_TYPE = 16;
    private static final int CP_INVOKE_DYNAMIC = 18;
    private static final int BYTE = 66;
    private static final int CHAR = 67;
    private static final int DOUBLE = 68;
    private static final int FLOAT = 70;
    private static final int INT = 73;
    private static final int LONG = 74;
    private static final int SHORT = 83;
    private static final int BOOLEAN = 90;
    private static final int STRING = 115;
    private static final int ENUM = 101;
    private static final int CLASS = 99;
    private static final int ANNOTATION = 64;
    private static final int ARRAY = 91;
    private final ClassFileBuffer cpBuffer = new ClassFileBuffer();
    private final Map<String, Class<? extends Annotation>> annotations;
    private TypeReporter typeReporter;
    private FieldReporter fieldReporter;
    private MethodReporter methodReporter;
    private String typeName;
    private Object[] constantPool;
    private String memberName;

    public AnnotationDetector(Reporter reporter) {
        Class<? extends Annotation>[] classArray = reporter.annotations();
        this.annotations = new HashMap<String, Class<? extends Annotation>>(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            this.annotations.put("L" + classArray[i].getName().replace('.', '/') + ";", classArray[i]);
        }
        if (reporter instanceof TypeReporter) {
            this.typeReporter = (TypeReporter)reporter;
        }
        if (reporter instanceof FieldReporter) {
            this.fieldReporter = (FieldReporter)reporter;
        }
        if (reporter instanceof MethodReporter) {
            this.methodReporter = (MethodReporter)reporter;
        }
        if (this.typeReporter == null && this.fieldReporter == null && this.methodReporter == null) {
            throw new AssertionError((Object)"No reporter defined");
        }
    }

    public void detect() throws IOException {
        this.detect(new ClassFileIterator());
    }

    public void detect(String ... stringArray) throws IOException {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i].replace('.', '/');
            if (stringArray2[i].endsWith("/")) continue;
            stringArray2[i] = stringArray2[i].concat("/");
        }
        HashSet<File> hashSet = new HashSet<File>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String string : stringArray2) {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                File file;
                URL uRL = enumeration.nextElement();
                if ("file".equals(uRL.getProtocol())) {
                    file = this.toFile(uRL);
                    if (file.isDirectory()) {
                        hashSet.add(file);
                        continue;
                    }
                    throw new AssertionError((Object)("Not a recognized file URL: " + uRL));
                }
                if (uRL.getProtocol().startsWith("vfs")) {
                    this.detect(new VfsResourceIterator(uRL));
                    continue;
                }
                if ("zip".equals(uRL.getProtocol())) {
                    uRL = new URL(uRL.toExternalForm().replace("zip:/", "jar:file:/"));
                }
                if ((file = this.toFile(((JarURLConnection)uRL.openConnection()).getJarFileURL())).isFile()) {
                    hashSet.add(file);
                    continue;
                }
                throw new AssertionError((Object)("Not a File: " + file));
            }
        }
        if (!hashSet.isEmpty()) {
            this.detect(new ClassFileIterator(hashSet.toArray(new File[hashSet.size()]), stringArray2));
        }
    }

    public void detect(File ... fileArray) throws IOException {
        this.detect(new ClassFileIterator(fileArray, null));
    }

    private File toFile(URL uRL) {
        try {
            return new File(uRL.toURI().getPath());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)("Unable to convert URI to File: " + uRL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detect(ResourceIterator resourceIterator) throws IOException {
        InputStream inputStream;
        while ((inputStream = resourceIterator.next()) != null) {
            try {
                this.cpBuffer.readFrom(inputStream);
                if (!this.hasCafebabe(this.cpBuffer)) continue;
                this.detect(this.cpBuffer);
            }
            catch (Throwable throwable) {
                if (inputStream instanceof FileInputStream) continue;
                inputStream.close();
            }
            finally {
                if (!(inputStream instanceof FileInputStream)) continue;
                inputStream.close();
            }
        }
    }

    private boolean hasCafebabe(ClassFileBuffer classFileBuffer) throws IOException {
        return classFileBuffer.size() > 4 && classFileBuffer.readInt() == -889275714;
    }

    private void detect(DataInput dataInput) throws IOException {
        this.readVersion(dataInput);
        this.readConstantPoolEntries(dataInput);
        this.readAccessFlags(dataInput);
        this.readThisClass(dataInput);
        this.readSuperClass(dataInput);
        this.readInterfaces(dataInput);
        this.readFields(dataInput);
        this.readMethods(dataInput);
        this.readAttributes(dataInput, 'T', this.typeReporter == null);
    }

    private void readVersion(DataInput dataInput) throws IOException {
        dataInput.skipBytes(4);
    }

    private void readConstantPoolEntries(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        this.constantPool = new Object[n];
        for (int i = 1; i < n; ++i) {
            if (!this.readConstantPoolEntry(dataInput, i)) continue;
            ++i;
        }
    }

    private boolean readConstantPoolEntry(DataInput dataInput, int n) throws IOException {
        int n2 = dataInput.readUnsignedByte();
        switch (n2) {
            case 16: {
                dataInput.skipBytes(2);
                return false;
            }
            case 15: {
                dataInput.skipBytes(3);
                return false;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                dataInput.skipBytes(4);
                return false;
            }
            case 5: 
            case 6: {
                dataInput.skipBytes(8);
                return true;
            }
            case 1: {
                this.constantPool[n] = dataInput.readUTF();
                return false;
            }
            case 7: 
            case 8: {
                this.constantPool[n] = dataInput.readUnsignedShort();
                return false;
            }
        }
        throw new ClassFormatError("Unkown tag value for constant pool entry: " + n2);
    }

    private void readAccessFlags(DataInput dataInput) throws IOException {
        dataInput.skipBytes(2);
    }

    private void readThisClass(DataInput dataInput) throws IOException {
        this.typeName = this.resolveUtf8(dataInput);
    }

    private void readSuperClass(DataInput dataInput) throws IOException {
        dataInput.skipBytes(2);
    }

    private void readInterfaces(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        dataInput.skipBytes(n * 2);
    }

    private void readFields(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            this.readAccessFlags(dataInput);
            this.memberName = this.resolveUtf8(dataInput);
            String string = this.resolveUtf8(dataInput);
            this.readAttributes(dataInput, 'F', this.fieldReporter == null);
        }
    }

    private void readMethods(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            this.readAccessFlags(dataInput);
            this.memberName = this.resolveUtf8(dataInput);
            String string = this.resolveUtf8(dataInput);
            this.readAttributes(dataInput, 'M', this.methodReporter == null);
        }
    }

    private void readAttributes(DataInput dataInput, char c, boolean bl) throws IOException {
        int n = dataInput.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            String string = this.resolveUtf8(dataInput);
            int n2 = dataInput.readInt();
            if (!bl && ("RuntimeVisibleAnnotations".equals(string) || "RuntimeInvisibleAnnotations".equals(string))) {
                this.readAnnotations(dataInput, c);
                continue;
            }
            dataInput.skipBytes(n2);
        }
    }

    private void readAnnotations(DataInput dataInput, char c) throws IOException {
        int n = dataInput.readUnsignedShort();
        block5: for (int i = 0; i < n; ++i) {
            String string = this.readAnnotation(dataInput);
            Class<? extends Annotation> clazz = this.annotations.get(string);
            if (clazz == null) continue;
            String string2 = this.typeName.replace('/', '.');
            switch (c) {
                case 'T': {
                    this.typeReporter.reportTypeAnnotation(clazz, string2);
                    continue block5;
                }
                case 'F': {
                    this.fieldReporter.reportFieldAnnotation(clazz, string2, this.memberName);
                    continue block5;
                }
                case 'M': {
                    this.methodReporter.reportMethodAnnotation(clazz, string2, this.memberName);
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("reporterType=" + c));
                }
            }
        }
    }

    private String readAnnotation(DataInput dataInput) throws IOException {
        String string = this.resolveUtf8(dataInput);
        int n = dataInput.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            dataInput.skipBytes(2);
            this.readAnnotationElementValue(dataInput);
        }
        return string;
    }

    private void readAnnotationElementValue(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        switch (n) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dataInput.skipBytes(2);
                break;
            }
            case 101: {
                dataInput.skipBytes(4);
                break;
            }
            case 99: {
                dataInput.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(dataInput);
                break;
            }
            case 91: {
                int n2 = dataInput.readUnsignedShort();
                for (int i = 0; i < n2; ++i) {
                    this.readAnnotationElementValue(dataInput);
                }
                break;
            }
            default: {
                throw new ClassFormatError("Not a valid annotation element type tag: 0x" + Integer.toHexString(n));
            }
        }
    }

    private String resolveUtf8(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        Object object = this.constantPool[n];
        String string = object instanceof Integer ? (String)this.constantPool[(Integer)object] : (String)object;
        return string;
    }

    private static void print(String string, Object ... objectArray) {
    }

    public static interface MethodReporter
    extends Reporter {
        public void reportMethodAnnotation(Class<? extends Annotation> var1, String var2, String var3);
    }

    public static interface FieldReporter
    extends Reporter {
        public void reportFieldAnnotation(Class<? extends Annotation> var1, String var2, String var3);
    }

    public static interface TypeReporter
    extends Reporter {
        public void reportTypeAnnotation(Class<? extends Annotation> var1, String var2);
    }

    public static interface Reporter {
        public Class<? extends Annotation>[] annotations();
    }
}

