/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.decoder.CascadeDecoder;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.ext.FunctionInvokerInterceptor;
import io.higson.runtime.helper.TypeConverter;
import java.util.Arrays;

public class StdFunctionInterceptor
implements FunctionInvokerInterceptor {
    private final TypeConverter type = TypeConverter.getInstance();
    private final HigsonEngine engine;
    private final CascadeDecoder decoder;

    public StdFunctionInterceptor(HigsonEngine engine) {
        this.decoder = new CascadeDecoder(engine);
        this.engine = engine;
    }

    @Override
    public Object invokeFunction(String name, ParamContext ctx, Object ... args) {
        String text = name.trim();
        if (text.startsWith("$f ")) {
            return this.decoder.cascadeCall(text.substring(3), ctx);
        }
        if (text.startsWith("$p ")) {
            return this.cascadeToParameter(ctx, text);
        }
        return this.engine.call(name, ctx, args);
    }

    private Object cascadeToParameter(ParamContext ctx, String text) {
        String[] cascadeResults = (String[])Arrays.stream(this.decoder.cascadeGet(text.substring(3), ctx)).map(this.type::getString).toArray(String[]::new);
        return cascadeResults.length == 1 ? cascadeResults[0] : cascadeResults;
    }
}

