/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.domain;

import io.higson.runtime.core.domain.AbstractDomainCacheManager;
import io.higson.runtime.core.domain.CacheKey;
import io.higson.runtime.core.domain.MpDomainCacheProvider;
import io.higson.runtime.core.domain.MpDomainRefreshController;
import io.higson.runtime.core.domain.WatcherDomainCacheManager;
import io.higson.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import io.higson.runtime.core.versioninterceptor.EffectiveVersionResolver;
import io.higson.runtime.model.DomainObject;
import io.higson.runtime.model.TreeDomain;
import java.time.LocalDateTime;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpDomainCacheManager
extends AbstractDomainCacheManager
implements WatcherDomainCacheManager {
    private static final Logger log = LoggerFactory.getLogger(MpDomainCacheManager.class);
    private final EffectiveVersionResolver effectiveVersionResolver;
    private Map<CacheKey, TreeDomainWrapper> headRegionVersionElementsByProfiles = new ConcurrentHashMap<CacheKey, TreeDomainWrapper>();

    public MpDomainCacheManager(MpDomainCacheProvider cacheProvider, EffectiveVersionResolver effectiveVersionResolver, MpDomainRefreshController refreshController) {
        super(cacheProvider, refreshController);
        this.effectiveVersionResolver = effectiveVersionResolver;
    }

    @Override
    public Set<String> getProfiles() {
        TreeSet<String> profiles = new TreeSet<String>(super.getProfilesFromHead());
        profiles.addAll(this.getProfilesFromRegionVersionCache());
        log.trace("getProfiles() found: {}", (Object)profiles);
        return profiles;
    }

    private Set<String> getProfilesFromRegionVersionCache() {
        return this.headRegionVersionElementsByProfiles.keySet().stream().map(CacheKey::getProfile).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getAllProfiles() {
        Set<String> allProfiles = super.getHeadAndSessionProfiles();
        allProfiles.addAll(this.getProfilesFromRegionVersionCache());
        log.trace("getAllProfiles() found: {}", (Object)allProfiles);
        return allProfiles;
    }

    @Override
    public DomainObject getByPath(String profileCode, String path, EffectiveVersionConfiguration configuration) {
        TreeDomainWrapper treeDomainWrapper;
        log.trace("enter getByPath({}, {}, {})", profileCode, path, configuration);
        Set<Integer> currentVersionsWithinProfile = this.effectiveVersionResolver.getEffectiveVersionIds(profileCode, configuration);
        CacheKey cacheKey = new CacheKey(profileCode, currentVersionsWithinProfile);
        if (this.headElementsByProfiles.get(profileCode) == null && this.headRegionVersionElementsByProfiles.get(cacheKey) == null) {
            this.refreshController.updateTimestampsForProfile(profileCode);
            this.refreshHeads(profileCode, configuration);
        }
        if ((treeDomainWrapper = this.headRegionVersionElementsByProfiles.get(cacheKey)) != null) {
            log.debug("returning domain from region version cache, key:{}", (Object)cacheKey);
            treeDomainWrapper.updateLastFetchTime();
            return treeDomainWrapper.getTreeDomain().getObjectsByPath(path);
        }
        if (this.headElementsByProfiles.get(profileCode) == null) {
            return null;
        }
        return ((TreeDomain)this.headElementsByProfiles.get(profileCode)).getObjectsByPath(path);
    }

    @Override
    protected void refreshHeads(String profileCode, EffectiveVersionConfiguration configuration) {
        TreeDomain treeDomain = this.cacheProvider.createDomainTree(profileCode, configuration);
        Set<Integer> currentVersionsWithinProfile = this.effectiveVersionResolver.getEffectiveVersionIds(profileCode, configuration);
        CacheKey cacheKey = new CacheKey(profileCode, currentVersionsWithinProfile);
        if (treeDomain.isAnyRoot()) {
            if (currentVersionsWithinProfile.isEmpty()) {
                log.debug("put domain tree to headElementsByProfiles cache for {}", (Object)profileCode);
                this.headElementsByProfiles.put(profileCode, treeDomain);
            } else {
                log.debug("put domain tree to headRegionVersionElementsByProfiles cache for: {}", (Object)cacheKey);
                this.headRegionVersionElementsByProfiles.put(cacheKey, new TreeDomainWrapper(treeDomain));
            }
        } else {
            log.debug("try removing tree by profileCode and versions {}", (Object)cacheKey);
            boolean wasRemoved = this.headRegionVersionElementsByProfiles.entrySet().removeIf(pair -> Objects.equals(cacheKey, pair.getKey()));
            if (!wasRemoved) {
                log.debug("remove domain trees by profile {}, because cache key couldn't be matched", (Object)profileCode);
                this.headRegionVersionElementsByProfiles.entrySet().removeIf(pair -> Objects.equals(profileCode, ((CacheKey)pair.getKey()).getProfile()));
            }
            this.headElementsByProfiles.remove(profileCode);
        }
    }

    @Override
    public DomainObject getSessionElementByPath(String profileCode, String user, String path, EffectiveVersionConfiguration configuration) {
        log.trace("enter getSessionElementByPath(profile={},user={}, path={}, configuration:{})", profileCode, user, path, configuration);
        CacheKey cacheKey = this.cacheProvider.createCacheKeyByConfiguration(user, profileCode, configuration);
        if (this.sessionElementsByCacheKey.get(cacheKey) == null) {
            this.refreshSessionsOfProfileAndUser(profileCode, user, configuration);
            if (this.sessionElementsByCacheKey.get(cacheKey) == null) {
                return null;
            }
        }
        return ((TreeDomain)this.sessionElementsByCacheKey.get(cacheKey)).getObjectsByPath(path);
    }

    @Override
    public void refreshProfile(String profileCode) {
        long start = System.currentTimeMillis();
        log.info("enter refreshProfile({})", (Object)profileCode);
        this.refreshHeads(profileCode);
        this.refreshSessionsOfProfile(profileCode);
        log.info("refreshProfile {}  finished in {} ms", (Object)profileCode, (Object)(System.currentTimeMillis() - start));
    }

    private void refreshSessionsOfProfile(String profileCode) {
        log.trace("enter refreshSessionsOfProfile({})", (Object)profileCode);
        if (this.sessionElementsByCacheKey.isEmpty()) {
            return;
        }
        List<String> profilesList = this.getProfilesFromSessionsMap();
        for (String userProfile : profilesList) {
            if (!userProfile.endsWith("@" + profileCode)) continue;
            String user = StringUtils.substringBefore(userProfile, "@");
            this.refreshSessionsOfProfileAndUser(profileCode, user, null);
        }
    }

    private List<String> getProfilesFromSessionsMap() {
        return this.sessionElementsByCacheKey.keySet().stream().map(CacheKey::getProfile).collect(Collectors.toList());
    }

    @Override
    public boolean wasSomethingChange() {
        return this.refreshController.wasSomethingChange(this.getAllProfiles());
    }

    @Override
    public Map<String, Date> getLastUpdatesByProfile() {
        return this.refreshController.getLastUpdatesByProfile();
    }

    @Override
    public Set<String> getPossibleModification(Map<String, Date> lastUpdatesByProfile) {
        return this.refreshController.getPossibleModification(lastUpdatesByProfile, this.getAllProfiles());
    }

    @Override
    public void updateProfileController(String profile2, Map<String, Date> lastUpdatesByProfile) {
        this.refreshController.updateTimestampByProfile(lastUpdatesByProfile, profile2);
    }

    @Override
    public void doWatch() {
        if (this.wasSomethingChange()) {
            this.refreshProfiles();
        }
    }

    private void refreshProfiles() {
        log.debug("possible domain element/type/type attribute or region version modification");
        Map<String, Date> lastUpdatesByProfile = this.getLastUpdatesByProfile();
        log.debug("fetched {} profiles with its last update time", (Object)lastUpdatesByProfile.size());
        for (String profile2 : this.getPossibleModification(lastUpdatesByProfile)) {
            log.debug("refreshing profile:{}", (Object)profile2);
            this.refreshProfile(profile2);
            this.updateProfileController(profile2, lastUpdatesByProfile);
        }
    }

    @Override
    public void invalidateTreeVersionCachesAfter(int invalidateValue, TemporalUnit unit) {
        log.debug("invalidating tree version cache");
        LocalDateTime currentTime = LocalDateTime.now();
        log.trace("before invalidate headRegionVersionElementsByProfiles cache size: {}", (Object)this.headRegionVersionElementsByProfiles.size());
        this.headRegionVersionElementsByProfiles.entrySet().removeIf(entry -> this.canRemoveEntry(invalidateValue, unit, currentTime, (Map.Entry<CacheKey, TreeDomainWrapper>)entry));
        log.trace("after invalidate headRegionVersionElementsByProfiles cache size: {}", (Object)this.headRegionVersionElementsByProfiles.size());
        log.debug("invalidating tree version cache finished");
    }

    private boolean canRemoveEntry(int invalidateValue, TemporalUnit unit, LocalDateTime currentTime, Map.Entry<CacheKey, TreeDomainWrapper> entry) {
        LocalDateTime treeLifespan = entry.getValue().getLastFetchTime().plus(invalidateValue, unit);
        return treeLifespan.isBefore(currentTime);
    }

    class TreeDomainWrapper {
        private final TreeDomain treeDomain;
        private LocalDateTime lastFetchTime;

        TreeDomainWrapper(TreeDomain treeDomain) {
            this.treeDomain = treeDomain;
            this.lastFetchTime = LocalDateTime.now();
        }

        void updateLastFetchTime() {
            this.lastFetchTime = LocalDateTime.now();
        }

        public TreeDomain getTreeDomain() {
            return this.treeDomain;
        }

        public LocalDateTime getLastFetchTime() {
            return this.lastFetchTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TreeDomainWrapper)) {
                return false;
            }
            TreeDomainWrapper other = (TreeDomainWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TreeDomain this$treeDomain = this.getTreeDomain();
            TreeDomain other$treeDomain = other.getTreeDomain();
            if (this$treeDomain == null ? other$treeDomain != null : !this$treeDomain.equals(other$treeDomain)) {
                return false;
            }
            LocalDateTime this$lastFetchTime = this.getLastFetchTime();
            LocalDateTime other$lastFetchTime = other.getLastFetchTime();
            return !(this$lastFetchTime == null ? other$lastFetchTime != null : !((Object)this$lastFetchTime).equals(other$lastFetchTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TreeDomainWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TreeDomain $treeDomain = this.getTreeDomain();
            result = result * 59 + ($treeDomain == null ? 43 : $treeDomain.hashCode());
            LocalDateTime $lastFetchTime = this.getLastFetchTime();
            result = result * 59 + ($lastFetchTime == null ? 43 : ((Object)$lastFetchTime).hashCode());
            return result;
        }
    }
}

