/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.dao.parameter;

import io.higson.runtime.alias.LevelMapper;
import io.higson.runtime.core.versioninterceptor.VersionInterceptor;
import io.higson.runtime.dao.BaseDao;
import io.higson.runtime.dao.parameter.GetNamesByRegionsInProfilesQueryBuilder;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.dao.util.RowMapper;
import io.higson.runtime.decoder.MpDecodingStrategy;
import io.higson.runtime.engine.core.UnknownParameterException;
import io.higson.runtime.engine.core.parameter.MatchMode;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.helper.MpHelper;
import io.higson.runtime.helper.uid.Uid;
import io.higson.runtime.helper.uid.UidParser;
import io.higson.runtime.model.MpParameterEntry;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.model.ParameterLevel;
import io.higson.runtime.provider.external.ExtSqlExecutor;
import io.higson.runtime.sql.DialectRegistry;
import io.higson.runtime.sql.DialectTemplate;
import io.higson.runtime.sync.Trackable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterJdbcDao
extends BaseDao {
    private static final Logger log = LoggerFactory.getLogger(ParameterJdbcDao.class);
    private static final int IX1 = 1;
    private static final int IX2 = 2;
    private static final int IX3 = 3;
    private static final int IX4 = 4;
    private static final int IX5 = 5;
    private static final int IX6 = 6;
    private static final int IX7 = 7;
    private static final int IX8 = 8;
    private static final int MATRIX_FETCH_SIZE = 500;
    private final MpHelper helper = new MpHelper();
    private final DialectTemplate dialect = DialectRegistry.getDialectTemplate();
    private final MpDecodingStrategy decodingStrategy;
    private final ExtSqlExecutor extSqlExecutor;
    private VersionInterceptor interceptor;

    public ParameterJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor, MpDecodingStrategy decodingStrategy, ExtSqlExecutor extSqlExecutor) {
        super(dataSource, connectionInterceptor);
        this.setDefaultFetchSize(100);
        this.decodingStrategy = decodingStrategy;
        this.extSqlExecutor = extSqlExecutor;
    }

    public ParameterJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        this(dataSource, connectionInterceptor, null, null);
    }

    public Parameter getParameter(String code, String ver, int sid) {
        return this.getParameter(code, ver, sid, 0);
    }

    public Parameter getParameter(String code, String ver, int sid, int mid) {
        log.debug("enter getParameter, param={}, ver={}, sid={}, mid={}", code, ver, sid, mid);
        long t = System.currentTimeMillis();
        Parameter p = this.fetchParameter(code, ver, sid, 0);
        if (p == null) {
            return null;
        }
        this.fetchLevels(p);
        p.postprocess();
        if (p.isSlave()) {
            this.prepareSlave(p, mid);
        }
        if (p.isCacheable()) {
            this.fetchMatrix(p);
        }
        log.debug("leave getParameter, time={}, p={}", (Object)(System.currentTimeMillis() - t), (Object)p);
        return p;
    }

    private void prepareSlave(Parameter slave, int mid) {
        Parameter master;
        if (mid > 0) {
            log.debug("loading master metadata by pid:  {}", (Object)mid);
            master = this.fetchParameter(mid);
        } else {
            log.debug("loading master metadata using perspective...");
            String masterUid = slave.getMasterName();
            masterUid = this.interceptor.decorateParameterUid(masterUid);
            log.debug("using master uid: {}", (Object)masterUid);
            master = this.fetchParameter(masterUid);
        }
        log.debug("loaded master: {}", (Object)master);
        if (master == null) {
            log.info("failed to load master {} for slave = {}", (Object)slave.getMasterName(), (Object)slave.getName());
            throw new UnknownParameterException("master not found for slave: " + slave.getName());
        }
        this.fetchLevels(master);
        master.postprocess();
        LevelMapper levelMapper = new LevelMapper(master, slave);
        slave.setLevelMapper(levelMapper);
        slave.setMid(master.getId());
    }

    private Parameter fetchParameter(String code, String ver, int sid, int pid) {
        boolean bypid = pid != 0;
        boolean head = sid == 0;
        boolean version = ver != null;
        String sql = this.createParamSelect(ver, sid, pid);
        log.trace("using sql: {}", (Object)sql);
        ArrayList<Object> list = new ArrayList<Object>();
        if (bypid) {
            list.add(pid);
        } else {
            list.add(code);
            if (version) {
                list.add(ver);
            }
            if (!head) {
                list.add(sid);
            }
        }
        Object[] args = list.toArray();
        return this.getOne(sql, args, (ResultSet rs, int rowNum) -> {
            Parameter row = new Parameter();
            row.setId(rs.getInt("id"));
            row.setName(this.dialect.getString(rs, "name"));
            row.setCacheable(this.dialect.getBoolean(rs, "cacheable"));
            row.setNullable(this.dialect.getBoolean(rs, "dictionary"));
            row.setNullable(this.dialect.getBoolean(rs, "nullable"));
            row.setSortText(this.dialect.getString(rs, "sort"));
            row.setLastUpdate(this.dialect.getTimestamp(rs, "lastupdate"));
            row.setDigest(rs.getString("digest"));
            row.setSlave(rs.getBoolean("slave"));
            row.setMasterName(rs.getString("mastername"));
            row.setDistinct(rs.getBoolean("distinct_flag"));
            row.setExternalSource(rs.getBoolean("external_source"));
            if (row.isExternalSource()) {
                row.setExternalInMemQuery(rs.getString("external_inmem_query"));
                row.setExternalNonMemQuery(rs.getString("external_nonmem_query"));
                row.setExternalDataSource(rs.getString("external_datasource"));
            }
            row.setAutoRefresh(rs.getBoolean("auto_refresh"));
            row.setAutoRefreshPeriod(rs.getString("auto_refresh_period"));
            row.setLoadedNow();
            return row;
        });
    }

    private Parameter fetchParameter(int pid) {
        return this.fetchParameter(null, null, 0, pid);
    }

    private Parameter fetchParameter(String parameterUid) {
        Uid uid = UidParser.parseUid(parameterUid);
        return this.fetchParameter(uid.getCode(), uid.getVersion(), uid.getSid(), uid.getMid());
    }

    private String createParamSelect(String ver, int sid, int pid) {
        StringBuilder sb = new StringBuilder();
        boolean bypid = pid != 0;
        boolean head = sid == 0;
        boolean version = ver != null;
        sb.append(" select    p.id, p.$name, p.$cacheable, p.$nullable, p.$dictionary, p.$sort, p.lastupdate, p.slave, p.mastername, p.distinct_flag, p.digest,    p.external_source, p.external_inmem_query, p.external_nonmem_query, p.external_datasource,    p.auto_refresh, p.auto_refresh_period");
        if (bypid) {
            this.append(" from @parameter p", sb);
            this.append("   left join @regionversion rv on p.regionversion_id = rv.id", sb);
            this.append(" where p.id = ?", sb);
        } else if (version) {
            this.append(" from @parameter p", sb);
            this.append("   inner join @regionversion rv on p.regionversion_id = rv.id", sb);
            this.append(" where p.$name = ?", sb);
            this.append("   and rv.versionnumber = ?", sb);
            this.append("   and p.head = 1", sb, head);
            this.append("   and p.worksessionid = ?", sb, !head);
            this.append("   and p.$archive = 0", sb);
        } else {
            this.append(" from @parameter p", sb);
            this.append("   left join @regionversion rv on p.regionversion_id = rv.id", sb);
            this.append(" where p.$name = ?", sb);
            this.append("   and (rv.active is null or rv.active = 1)", sb);
            this.append("   and p.head = 1", sb, head);
            this.append("   and p.worksessionid = ?", sb, !head);
            this.append("   and p.$archive = 0", sb);
        }
        return this.dialect.parse(sb.toString());
    }

    private <T> T getOne(String sql, Object[] args, RowMapper<T> mapper) {
        List<T> result = this.jdbcTemplate(1).query(sql, args, mapper);
        if (result.size() == 1) {
            return result.get(0);
        }
        if (result.isEmpty()) {
            return null;
        }
        throw new HigsonRuntimeException("Too many records found for sql: \n" + sql);
    }

    private void append(String line, StringBuilder sb) {
        sb.append(line);
    }

    private void append(String line, StringBuilder sb, boolean condition) {
        if (condition) {
            this.append(line, sb);
        }
    }

    private void fetchLevels(Parameter p) {
        long pid = p.getId();
        String sql = this.dialect.parse(" select id, leveltype, orderno, $code, $type, matcher, reverse_matcher, $property, levelcreator, union_flag, $array_flag, $external_flag from @parameterlevel where parameter_id_in = ? or parameter_id_out = ? order by leveltype, orderno");
        this.jdbcTemplate().query(sql, rs -> {
            int id = rs.getInt("id");
            String levelType = rs.getString("leveltype");
            int orderNo = rs.getInt("orderno");
            String code = this.dialect.getString(rs, "code");
            String type = this.dialect.getString(rs, "type");
            String matcher = this.dialect.getString(rs, "matcher");
            boolean reverseMatcher = this.dialect.getBoolean(rs, "reverse_matcher");
            String property = this.dialect.getString(rs, "property");
            String levelCreator = rs.getString("levelcreator");
            boolean union = rs.getBoolean("union_flag");
            boolean array = this.dialect.getBoolean(rs, "array_flag");
            boolean ext = this.dialect.getBoolean(rs, "external_flag");
            ParameterLevel parameterLevel = new ParameterLevel();
            parameterLevel.setId(id);
            parameterLevel.setOrderNo(orderNo);
            parameterLevel.setName(code);
            parameterLevel.setType(type);
            parameterLevel.setMatcher(matcher);
            parameterLevel.setReverseMatcher(reverseMatcher);
            parameterLevel.setMatchMode(union ? MatchMode.UNION : MatchMode.STANDARD);
            parameterLevel.setArray(array);
            parameterLevel.setExternal(ext);
            if (levelCreator != null) {
                parameterLevel.setLevelCreator(levelCreator);
            } else if (property != null) {
                parameterLevel.setLevelCreator("prop:" + property);
            }
            p.addLevel(parameterLevel);
            if (levelType.equals("input")) {
                p.setInputLevels(p.getInputLevels() + 1);
            }
        }, pid, pid);
    }

    private void fetchMatrix(Parameter p) {
        if (p.isExternalSource()) {
            this.fetchMatrixExt(p);
        } else {
            this.fetchMatrixStd(p);
        }
    }

    private void fetchMatrixStd(Parameter p) {
        long pid = p.getId();
        long mid = p.getMid() > 0 ? (long)p.getMid() : pid;
        this.jdbcTemplate(500).query(this.dialect.parse(" select level1, level2, level3, level4, level5, level6, level7, level8  from @parameterentry #ix_pe_pid where parameter_id = ?"), rs -> {
            String[] levels = new String[]{this.str(rs, 1), this.str(rs, 2), this.str(rs, 3), this.str(rs, 4), this.str(rs, 5), this.str(rs, 6), this.str(rs, 7), this.str(rs, 8)};
            LevelMapper mapper = p.getLevelMapper();
            MpParameterEntry e = mapper != null && mapper.isNotIdentical() ? this.helper.createEntry(mapper, levels) : this.helper.createEntry(p, levels);
            e.intern();
            if (this.decodingStrategy != null) {
                this.decodingStrategy.detectCascadingRefs(p, e);
            }
            p.addEntry(e);
        }, mid);
        log.debug("leave fetchMatrix, pid={}, mid={}, size={}", pid, mid, p.getEntries().size());
    }

    private void fetchMatrixExt(Parameter p) {
        this.extSqlExecutor.fetchMatrixExt(p);
    }

    public Collection<ParameterEntry> findEntries(int pid, String[][] inputLevels) {
        if (log.isTraceEnabled()) {
            log.trace("enter findEntries, pid={}, levels={}", (Object)pid, (Object)Arrays.toString((Object[])inputLevels));
        }
        long t = System.currentTimeMillis();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(pid);
        String[][] columns = this.helper.toDatabaseColumns(inputLevels);
        StringBuilder sb = new StringBuilder(200);
        sb.append(" select level1, level2, level3, level4, level5, level6, level7, level8");
        sb.append(" from @parameterentry");
        sb.append(" where parameter_id = ?");
        for (int i = 0; i < columns.length; ++i) {
            String[] levelArgs = columns[i];
            boolean last = i == columns.length - 1;
            if ((levelArgs = (String[])Stream.of(levelArgs).filter(Objects::nonNull).toArray(String[]::new)).length == 0) {
                sb.append(this.isNullCondition(i));
                continue;
            }
            sb.append(this.createLevelSQLStatement(i, last, levelArgs.length));
            args.add(this.convertLogicArgsToSQLArgs(levelArgs));
        }
        String sql = this.dialect.parse(sb.toString());
        log.trace("using sql: {}", (Object)sql);
        ArrayList<ParameterEntry> result = new ArrayList<ParameterEntry>();
        this.jdbcTemplate(50).query(sql, args.toArray(), rs -> {
            String[] cells = new String[]{rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8)};
            result.add(this.helper.createEntry(cells));
        });
        log.trace("leave findEntries, size={}, time={}", (Object)result.size(), (Object)(System.currentTimeMillis() - t));
        return result;
    }

    private String isNullCondition(int i) {
        return String.format(" and level%d is null", i + 1);
    }

    private Object convertLogicArgsToSQLArgs(String[] levelArgs) {
        if (levelArgs.length == 1) {
            return levelArgs[0];
        }
        return levelArgs;
    }

    private String createLevelSQLStatement(int i, boolean last, int multipleArgs) {
        if (multipleArgs > 1) {
            return String.format(" and level%d in(%s)", i + 1, this.generateQuestionMarks(multipleArgs));
        }
        return String.format(" and level%d %s ?", i + 1, last ? "like" : "=");
    }

    private String generateQuestionMarks(int multipleArgs) {
        return IntStream.range(0, multipleArgs).mapToObj(k -> "?").collect(Collectors.joining(", "));
    }

    public Date getMaxLastUpdate() {
        return this.jdbcTemplate(1).queryForObject(this.dialect.parse("select max(lastupdate) from @parameter"), Date.class);
    }

    public Date getMaxLastUpdate(boolean developerMode) {
        String sql = developerMode ? "select max(lastupdate) from @parameter where archive = 0" : "select max(lastupdate) from @parameter where archive = 0 and head = 1";
        return this.jdbcTemplate(1).queryForObject(this.dialect.parse(sql), Date.class);
    }

    public List<Trackable> getAllLastUpdates(boolean developerMode) {
        long t = System.currentTimeMillis();
        String sql = developerMode ? "select id, $name, lastupdate from @parameter where archive = 0" : "select id, $name, lastupdate from @parameter where archive = 0 and head = 1";
        List<Trackable> result = this.jdbcTemplate(500).query(this.dialect.parse(sql), (rs, i) -> new Trackable(rs.getInt(1), rs.getString(2), rs.getTimestamp(3)));
        log.debug("leave getAllLastUpdates, size={}, time={}", (Object)result.size(), (Object)(System.currentTimeMillis() - t));
        return result;
    }

    public List<String> getNamesByRegionsInProfiles(Map<String, List<String>> profileToRegions) {
        ArrayList<String> result = new ArrayList<String>();
        GetNamesByRegionsInProfilesQueryBuilder queryBuilder = new GetNamesByRegionsInProfilesQueryBuilder();
        MutablePair<String, List<Object>> queryAndParams = queryBuilder.build(profileToRegions);
        String query = queryAndParams.getLeft();
        List<Object> params = queryAndParams.getRight();
        this.jdbcTemplate().query(this.dialect.parse(query), rs -> result.add(this.dialect.getString(rs, "paramName")), params.toArray());
        return result;
    }

    public List<Parameter> getAllHeads() {
        return this.jdbcTemplate(500).query(this.dialect.parse(" select id, $name, lastupdate, regionversion_id from @parameter where head = 1   and $archive = 0"), (rs, i) -> {
            Parameter p = new Parameter();
            p.setId(rs.getInt("id"));
            p.setName(this.dialect.getString(rs, "name"));
            p.setLastUpdate(this.dialect.getTimestamp(rs, "lastupdate"));
            p.setRegionVersionId(rs.getInt("regionversion_id"));
            return p;
        });
    }

    public Parameter getHeader(int pid) {
        return this.getOne(this.dialect.parse(" select $name, lastupdate, regionversion_id from @parameter where id = ? "), new Object[]{pid}, (ResultSet rs, int i) -> {
            Parameter p = new Parameter();
            p.setId(pid);
            p.setName(this.dialect.getString(rs, "name"));
            p.setLastUpdate(this.dialect.getTimestamp(rs, "lastupdate"));
            p.setRegionVersionId(rs.getInt("regionversion_id"));
            return p;
        });
    }

    private String str(ResultSet rs, int index) throws SQLException {
        return this.helper.unify(rs.getString(index));
    }

    public void setInterceptor(VersionInterceptor interceptor) {
        this.interceptor = interceptor;
    }
}

