/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.annotated;

public class RepositoryObjectKey
implements Comparable<RepositoryObjectKey> {
    private static final int DEFAULT_ORDER = 100;
    private final String key;
    private int order = 100;

    public RepositoryObjectKey(String key) {
        this.key = key;
    }

    public RepositoryObjectKey(String key, int order) {
        this.key = key;
        this.order = order;
    }

    public static RepositoryObjectKey withKey(String key) {
        return new RepositoryObjectKey(key);
    }

    public String getKey() {
        return this.key;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public int compareTo(RepositoryObjectKey other) {
        if (other.order == this.order) {
            return this.key.compareTo(other.key);
        }
        return this.order > other.order ? 1 : -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RepositoryObjectKey) {
            return this.key.equals(((RepositoryObjectKey)obj).key);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (this.key != null ? this.key.hashCode() : 0);
        return hash;
    }

    public String toString() {
        if (this.order < 0) {
            return this.key;
        }
        return "[key: " + this.key + " order: " + this.order + "]";
    }
}

