/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.repository;

import io.higson.runtime.engine.annotated.RepositoryObjectKey;
import io.higson.runtime.engine.core.repository.NonUniqueItemRegisteredException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRepository<V> {
    private static final Logger log = LoggerFactory.getLogger(MapRepository.class);
    private final Class<?> containedClass;
    private final Map<RepositoryObjectKey, V> repositoryMap;

    public MapRepository(Class<?> containedClass) {
        this(containedClass, new HashMap());
    }

    public MapRepository(Class<?> containedClass, Map<RepositoryObjectKey, V> repositoryMapInstance) {
        this.containedClass = containedClass;
        this.repositoryMap = repositoryMapInstance;
    }

    public boolean contains(RepositoryObjectKey key) {
        return this.repositoryMap.containsKey(key);
    }

    public boolean contains(String key) {
        return this.contains(RepositoryObjectKey.withKey(key));
    }

    public V getItem(RepositoryObjectKey key) {
        return this.repositoryMap.get(key);
    }

    public V getItem(String key) {
        return this.repositoryMap.get(RepositoryObjectKey.withKey(key));
    }

    public void register(RepositoryObjectKey key, V value) {
        log.debug("{} repository: registering {} under key {}", this.containedClass.getSimpleName(), value.getClass().getSimpleName(), key);
        this.repositoryMap.put(key, value);
    }

    public void register(String key, V value) {
        this.register(RepositoryObjectKey.withKey(key), value);
    }

    public void registerUnique(RepositoryObjectKey key, V value) {
        if (this.repositoryMap.containsKey(key)) {
            throw new NonUniqueItemRegisteredException(this.containedClass, key);
        }
        this.register(key, value);
    }

    public void registerUnique(String key, V value) {
        this.registerUnique(RepositoryObjectKey.withKey(key), value);
    }

    public void registerAll(Map<RepositoryObjectKey, V> items) {
        for (Map.Entry<RepositoryObjectKey, V> item : items.entrySet()) {
            this.register(item.getKey(), item.getValue());
        }
    }

    public void registerAllOrdered(Map<String, V> items) {
        int index = 0;
        for (Map.Entry<String, V> item : items.entrySet()) {
            this.register(new RepositoryObjectKey(item.getKey(), index), item.getValue());
            ++index;
        }
    }

    public void registerAllUnordered(Map<String, V> items) {
        for (Map.Entry<String, V> item : items.entrySet()) {
            this.register(RepositoryObjectKey.withKey(item.getKey()), item.getValue());
        }
    }

    public Map<String, V> getItemsUnordered() {
        return this.injectItemsUnwrapped(new HashMap());
    }

    public Map<String, V> getItemsOrdered() {
        return this.injectItemsUnwrapped(new LinkedHashMap());
    }

    private Map<String, V> injectItemsUnwrapped(Map<String, V> containerInstance) {
        for (Map.Entry<RepositoryObjectKey, V> item : this.repositoryMap.entrySet()) {
            containerInstance.put(item.getKey().getKey(), item.getValue());
        }
        return containerInstance;
    }
}

