/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.date;

import io.higson.runtime.engine.core.type.AbstractValueHolder;
import io.higson.runtime.engine.types.date.DateType;
import io.higson.runtime.engine.types.date.SimpleDateFormatPool;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class DateHolder
extends AbstractValueHolder {
    private final Date date;

    public DateHolder(Date date) {
        this.date = date;
    }

    @Override
    public Date getValue() {
        return this.date;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public Date getDatetime() {
        return this.date;
    }

    @Override
    public LocalDate getLocalDate() {
        return this.date != null ? this.date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        return this.date != null ? this.date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime() : null;
    }

    @Override
    public Long getLong() {
        return this.date != null ? Long.valueOf(this.date.getTime()) : null;
    }

    @Override
    public long longValue() {
        return this.date != null ? this.date.getTime() : 0L;
    }

    @Override
    public String getString() {
        return this.getString(DateType.getDefaultOutputPattern());
    }

    public String getString(String pattern) {
        return this.date != null ? SimpleDateFormatPool.get(pattern).format(this.date) : null;
    }
}

