/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.date;

import io.higson.runtime.engine.types.date.AbstractDateParserChain;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

class LocalDateParserChain
extends AbstractDateParserChain<LocalDate> {
    private LocalDateParserChain(DateTimeFormatter formatter) {
        super(formatter);
    }

    @Override
    protected LocalDate doParse(String text, DateTimeFormatter formatter) {
        return LocalDate.parse(text, formatter);
    }

    static LocalDateParserChain build() {
        LocalDateParserChain basicIsoDate = new LocalDateParserChain(DateTimeFormatter.BASIC_ISO_DATE);
        LocalDateParserChain isoLocalDate = new LocalDateParserChain(DateTimeFormatter.ISO_LOCAL_DATE);
        basicIsoDate.setNext(isoLocalDate);
        LocalDateParserChain isoOffsetDate = new LocalDateParserChain(DateTimeFormatter.ISO_OFFSET_DATE);
        isoLocalDate.setNext(isoOffsetDate);
        LocalDateParserChain isoDate = new LocalDateParserChain(DateTimeFormatter.ISO_DATE);
        isoOffsetDate.setNext(isoDate);
        LocalDateParserChain isoOrdinalDate = new LocalDateParserChain(DateTimeFormatter.ISO_ORDINAL_DATE);
        isoDate.setNext(isoOrdinalDate);
        LocalDateParserChain isoWeekDate = new LocalDateParserChain(DateTimeFormatter.ISO_WEEK_DATE);
        isoOrdinalDate.setNext(isoWeekDate);
        return basicIsoDate;
    }
}

