/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.ext.adapter;

import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.ext.adapter.Adapter;
import io.higson.runtime.ext.adapter.AdapterFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdapterFactoryImpl<E, A extends Adapter>
implements AdapterFactory<E> {
    private static Map<Class<? extends Adapter>, Constructor<? extends Adapter>> cache = new ConcurrentHashMap<Class<? extends Adapter>, Constructor<? extends Adapter>>();
    private final Class<A> adapterClass;

    @Override
    public Adapter create(E obj) {
        try {
            return (Adapter)this.getContructor(this.adapterClass, obj).newInstance(obj);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HigsonRuntimeException(String.format("failed to create Adapter [%s] for element: %s", this.adapterClass.getSimpleName(), obj), e);
        }
    }

    private Constructor<A> getContructor(Class<A> clazz, Object arg) {
        Constructor<Adapter> constr = cache.get(clazz);
        if (constr == null) {
            constr = this.findConstructor(arg);
            cache.put(clazz, constr);
        }
        return constr;
    }

    private Constructor<A> findConstructor(Object arg) {
        try {
            if (arg != null) {
                return this.adapterClass.getConstructor(arg.getClass());
            }
            return this.adapterClass.getConstructors()[0];
        }
        catch (NoSuchMethodException | RuntimeException e) {
            throw new HigsonRuntimeException(String.format("Failed to create Adapter [%s] for element: %s", this.adapterClass.getSimpleName(), arg), e);
        }
    }

    public AdapterFactoryImpl(Class<A> adapterClass) {
        this.adapterClass = adapterClass;
    }
}

