/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.function.log;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.function.log.FunctionLogLevelCache;
import io.higson.runtime.function.log.FunctionLogLevelResolver;
import io.higson.runtime.function.log.FunctionLogger;
import io.higson.runtime.function.log.ListenableLogger;
import io.higson.runtime.function.log.LogListener;
import io.higson.runtime.function.log.RuntimeLogger;
import io.higson.runtime.model.Function;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionLoggerCreator {
    private static final Logger log = LoggerFactory.getLogger(FunctionLoggerCreator.class);
    private static final String LOGGER_NAME_PATTERN = "function.%s";
    private final Collection<LogListener> logListeners;
    private final FunctionLogLevelCache logLevelCache;
    private FunctionLogLevelResolver functionLogLevelResolver;

    public FunctionLoggerCreator(Collection<LogListener> logListeners, FunctionLogLevelCache logLevelCache) {
        this.logListeners = logListeners;
        this.logLevelCache = logLevelCache;
    }

    public FunctionLoggerCreator(Collection<LogListener> logListeners) {
        this(logListeners, new FunctionLogLevelCache());
    }

    public FunctionLoggerCreator() {
        this(Collections.emptyList());
    }

    public RuntimeLogger createLogger(Function function) {
        String loggerName = String.format(LOGGER_NAME_PATTERN, function.getName());
        Logger logger = LoggerFactory.getLogger(loggerName);
        if (CollectionUtils.isNotEmpty(this.logListeners)) {
            return new ListenableLogger(new FunctionLogger(logger, function, this.functionLogLevelResolver), this.logListeners);
        }
        return new FunctionLogger(logger, function, this.functionLogLevelResolver);
    }

    public void setHigsonEngine(HigsonEngine higsonEngine) {
        this.functionLogLevelResolver = new FunctionLogLevelResolver(higsonEngine, this.logLevelCache);
        log.info("using function log level resolver: {}", (Object)this.functionLogLevelResolver);
    }
}

