/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.model;

import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.model.AttributeDefinition;
import io.higson.runtime.model.DomainAttribute;
import io.higson.runtime.model.DomainObject;
import io.higson.runtime.model.DomainObjectType;
import io.higson.runtime.model.DomainObjectTypeImpl;
import io.higson.runtime.model.DomainTokenResolver;
import io.higson.runtime.model.RegionCached;
import io.higson.runtime.model.Tag;
import io.higson.runtime.model.TreeDomain;
import io.higson.runtime.utils.hash.HashUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainObjectImpl
implements DomainObject,
Comparable<DomainObjectImpl> {
    private static final Logger log = LoggerFactory.getLogger(DomainObjectImpl.class);
    private static int tmpId = 200;
    private final Integer id;
    private Integer parentId;
    private final String code;
    private final String name;
    private final String description;
    private final DomainObjectTypeImpl collection;
    private List<DomainAttribute> dynamicAttributes;
    private Set<DomainObjectImpl> children = new TreeSet<DomainObjectImpl>();
    private List<DomainAttribute> attributes = Collections.emptyList();
    private Map<String, DomainAttribute> attrMap = Collections.emptyMap();
    private RegionCached region;
    private String path;
    private DomainObjectImpl parent;
    private Integer idToSelectChildren;
    private Integer sessionId;
    private boolean head;
    private List<Tag> tags = new ArrayList<Tag>();
    private Integer copyFrom;
    private Set<Integer> realChildrenIds = new TreeSet<Integer>();
    private Map<String, List<Integer>> referencesInCollections = new HashMap<String, List<Integer>>();
    private Map<Integer, String> collectionCodeByReferenceId = new HashMap<Integer, String>();
    private Map<String, DomainObject> childrenByToken = new HashMap<String, DomainObject>();
    private Map<String, Map<String, DomainObject>> childrenCascadeMap = new HashMap<String, Map<String, DomainObject>>();
    private Map<String, Set<DomainObject>> childrenByCollection = new HashMap<String, Set<DomainObject>>();

    public DomainObjectImpl() {
        this.id = null;
        this.code = "";
        this.name = "";
        this.description = "";
        this.collection = null;
        this.parentId = null;
    }

    public DomainObjectImpl(Integer id, String code, String name, String description, DomainObjectTypeImpl type, Integer parentId, boolean head) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.description = description;
        this.collection = type;
        this.parentId = parentId;
        this.head = head;
    }

    @Override
    public DomainObject getDomain(String objectPath) {
        if (log.isTraceEnabled()) {
            log.trace("getDomain({}) in object {}", (Object)objectPath, (Object)this);
        }
        if (this.isRootPath(objectPath)) {
            return this;
        }
        return this.processByPath(objectPath);
    }

    private DomainObject processByPath(String objectPath) {
        String pathToProcess = objectPath.startsWith("/") ? objectPath.substring(1) : objectPath;
        String[] tokens = pathToProcess.split("/");
        if (tokens.length == 1) {
            return this.getDomainByTokenOrCollection(tokens[0]);
        }
        DomainObject child = this.childrenByToken.get(tokens[0]);
        if (child == null) {
            return null;
        }
        return ((DomainObjectImpl)child).processByPath(pathToProcess.substring(pathToProcess.indexOf(47)));
    }

    private DomainObject getDomainByTokenOrCollection(String token) {
        if (token.contains("[")) {
            DomainObject child = this.childrenByToken.get(token);
            if (child != null) {
                return child;
            }
            int bracketIx = token.indexOf(91);
            String collName = token.substring(0, bracketIx);
            String elementCode = token.substring(bracketIx + 1, token.length() - 1);
            Set<DomainObject> collectionElements = this.childrenByCollection.get(collName);
            if (collectionElements != null) {
                for (DomainObject e : collectionElements) {
                    if (!e.getCode().equals(elementCode)) continue;
                    return e;
                }
            }
        } else {
            List<DomainObject> tmpChildren = this.getChildren(token);
            if (!tmpChildren.isEmpty()) {
                return tmpChildren.get(0);
            }
        }
        return null;
    }

    @Override
    public DomainObjectType getTypeCollection() {
        return this.collection;
    }

    @Override
    public List<Tag> getTagList() {
        return this.tags;
    }

    @Override
    public String getDigest() {
        ArrayList<String> digestElements = new ArrayList<String>();
        digestElements.add(this.code);
        digestElements.add(this.getTypeCode());
        String attributeDigests = this.getConcatenatedAttributesDigest();
        digestElements.add(attributeDigests);
        if (this.region != null) {
            digestElements.add(this.region.getRegionCode());
            digestElements.add(this.region.getVersionNumber());
        }
        return HashUtils.sha1(digestElements.toArray(new String[0]));
    }

    private String getConcatenatedAttributesDigest() {
        return this.getAttributes().stream().map(DomainAttribute::getDigest).filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    public List<String> getTagsName() {
        return this.tags.stream().map(Tag::getName).collect(Collectors.toList());
    }

    public void addAllTags(List<Tag> tagList) {
        if (tagList != null) {
            this.tags.clear();
            this.tags.addAll(tagList);
        }
    }

    @Override
    public boolean isRoot() {
        return this.path == null || this.isRootPath(this.path);
    }

    @Override
    public boolean isAttrDefined(String code) {
        DomainObjectType type = this.getTypeCollection();
        AttributeDefinition attrDef = null;
        if (type != null) {
            attrDef = type.getAttributeDefinition(code);
        }
        return attrDef != null;
    }

    @Override
    public boolean isLocalAttr(String code) {
        return this.getDynamicAttribute(code) != null;
    }

    @Override
    public DomainAttribute getAttr(String code) {
        return this.getAttribute(code);
    }

    @Override
    public String getAttrString(String code, HigsonContext ctx) {
        return this.getAttribute(code).getString(ctx);
    }

    @Override
    public BigDecimal getAttrDecimal(String code, HigsonContext ctx) {
        return this.getAttribute(code).getDecimal(ctx);
    }

    @Override
    public double getAttrNumber(String code, HigsonContext ctx) {
        return this.getAttribute(code).getNumber(ctx);
    }

    @Override
    public Integer getAttrInteger(String code, HigsonContext ctx) {
        return this.getAttribute(code).getInteger(ctx);
    }

    @Override
    public Date getAttrDate(String code, HigsonContext ctx) {
        return this.getAttribute(code).getDate(ctx);
    }

    @Override
    public boolean getAttrBoolean(String code, HigsonContext ctx) {
        return this.getAttribute(code).booleanValue(ctx);
    }

    @Override
    public String getTypeName() {
        return this.collection == null ? "" : this.collection.getTypeName();
    }

    @Override
    public String getTypeCode() {
        return this.collection == null ? "" : this.collection.getTypeCode();
    }

    @Override
    public DomainAttribute getAttribute(String code) {
        return this.attrMap.get(code);
    }

    @Override
    public DomainAttribute getDynamicAttribute(String code) {
        for (DomainAttribute attr : this.getDynamicAttributes()) {
            if (!attr.getCode().equals(code)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public Optional<DomainAttribute> getFromAllAttributes(String code) {
        DomainAttribute attribute = this.getAttribute(code);
        if (attribute == null) {
            attribute = this.getDynamicAttribute(code);
        }
        return Optional.ofNullable(attribute);
    }

    @Override
    public List<DomainAttribute> getDynamicAttributes() {
        if (this.dynamicAttributes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.dynamicAttributes);
    }

    @Override
    public DomainObject getChild(String propCode, String code) {
        if (code != null) {
            return this.getChildFromMap(propCode, code);
        }
        List<DomainObject> propChildren = this.getChildren(propCode);
        if (propChildren.size() == 1) {
            return propChildren.get(0);
        }
        if (!propChildren.isEmpty() && ((DomainObjectImpl)propChildren.get((int)0)).collection.isMultiple()) {
            throw new HigsonRuntimeException(String.format("To get element from collection you have to provide elementCode: %s[null]", propCode));
        }
        return null;
    }

    private DomainObject getChildFromMap(String key1, String key2) {
        Map<String, DomainObject> sub = this.childrenCascadeMap.get(key1);
        return sub != null ? sub.get(key2) : null;
    }

    @Override
    public List<DomainObject> getChildren(String propCode) {
        Set<DomainObject> childrenTmp = this.childrenByCollection.get(propCode);
        List<Object> children2 = childrenTmp == null ? Collections.emptyList() : new ArrayList<DomainObject>(childrenTmp);
        return Collections.unmodifiableList(children2);
    }

    @Override
    public DomainObjectImpl getParent() {
        if (this.parent == null) {
            throw new HigsonRuntimeException("Parent not set - first element in the tree");
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public DomainAttribute getAttribute(String path, String attributeCode) {
        DomainObject object = this.getDomain(path);
        if (object == null) {
            return null;
        }
        return object.getAttribute(attributeCode);
    }

    @Override
    public ParamValue getAttributeValue(String path, String attributeCode, ParamContext ctx, Object ... args) {
        if (ctx == null) {
            return null;
        }
        DomainAttribute attribute = this.getAttribute(path, attributeCode);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue(ctx, args);
    }

    @Override
    public String getCallPath() {
        return this.getFullPath();
    }

    public void setChildren(List<DomainObjectImpl> children) {
        this.children = new TreeSet<DomainObjectImpl>(children);
        for (DomainObjectImpl child : children) {
            this.addChild(child);
        }
    }

    private void addChild(DomainObjectImpl child) {
        this.childrenByToken.put(TreeDomain.fullTokenResolver(child.getCollection().getCode(), child.getCode()), child);
        this.childCascadePut(child);
        this.addChildToCollectionMap(child.getCollection().getCode(), child);
        this.realChildrenIds.add(child.getId());
    }

    private void childCascadePut(DomainObjectImpl child) {
        this.childCascadePut(child, child.getCollection().getCode());
    }

    private void childCascadePut(DomainObjectImpl child, String referenceInCollectionCode) {
        String k2 = child.getCode();
        Map submap = this.childrenCascadeMap.computeIfAbsent(referenceInCollectionCode, k -> new HashMap());
        submap.put(k2, child);
    }

    private void childCascadeRemove(String k1, String k2) {
        Map<String, DomainObject> submap = this.childrenCascadeMap.get(k1);
        if (submap != null) {
            submap.remove(k2);
        }
    }

    private void addChildToCollectionMap(String collCode, DomainObject child) {
        Set elements = this.childrenByCollection.computeIfAbsent(collCode, k -> new TreeSet());
        elements.add(child);
    }

    public void setAttributes(List<DomainAttribute> attributes) {
        this.attributes = Collections.unmodifiableList(this.notnull(attributes));
        this.attrMap = new HashMap<String, DomainAttribute>(this.attributes.size() * 2);
        for (DomainAttribute attr : this.attributes) {
            this.attrMap.put(attr.getCode(), attr);
        }
    }

    private List<DomainAttribute> notnull(List<DomainAttribute> list) {
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public String getFullElementCode() {
        return Objects.isNull(this.collection) ? null : DomainTokenResolver.resolveFullToken(this.collection.getCode(), this.code);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HigsonDomainObject[#");
        builder.append(this.id);
        builder.append(" code=");
        builder.append(this.code);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", typeId=");
        builder.append(this.collection == null ? "null" : this.collection.getId());
        builder.append(", parentId=");
        builder.append(this.parentId);
        builder.append(", path=");
        builder.append(this.path);
        if (this.copyFrom != null && this.copyFrom > 0) {
            builder.append(", copyFrom=");
            builder.append(this.copyFrom);
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.code.hashCode();
        if (Objects.nonNull(this.collection)) {
            result = 31 * result + Objects.hashCode(this.collection.getCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainObjectImpl other = (DomainObjectImpl)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append(this.code, other.code);
        if (Objects.nonNull(this.collection)) {
            equalsBuilder.append(this.collection.getCode(), other.collection == null ? null : other.collection.getCode());
        }
        return equalsBuilder.isEquals();
    }

    private boolean isRootPath(String objectPath) {
        return StringUtils.isBlank(objectPath) || objectPath.equals("/");
    }

    public DomainObjectType getCollection() {
        return this.getTypeCollection();
    }

    public void addReference(DomainObjectImpl referenced, String referenceInCollectionCode) {
        if ("!!".equals(referenced.getCode())) {
            return;
        }
        this.children.add(referenced);
        this.childrenByToken.put(TreeDomain.fullTokenResolver(referenced.getCollection().getCode(), referenced.getCode()), referenced);
        this.childCascadePut(referenced, referenceInCollectionCode);
        this.addChildToCollectionMap(referenceInCollectionCode, referenced);
        List<Integer> ids = this.referencesInCollections.get(referenceInCollectionCode);
        if (ids == null) {
            ids = new ArrayList<Integer>();
        }
        ids.add(referenced.id);
        this.referencesInCollections.put(referenceInCollectionCode, ids);
        for (Integer referenceId : ids) {
            this.collectionCodeByReferenceId.put(referenceId, referenceInCollectionCode);
        }
    }

    public String getTypeNature() {
        return Objects.isNull(this.collection) ? null : this.collection.getTypeNature();
    }

    public String getCollectionType() {
        return Objects.isNull(this.collection) ? null : this.collection.getTypeCode();
    }

    public boolean isRealChild(Integer id) {
        return this.realChildrenIds.contains(id);
    }

    public boolean isReferenceInCollection(String collectionCode, Integer id) {
        return this.referencesInCollections.get(collectionCode) != null && this.referencesInCollections.get(collectionCode).contains(id);
    }

    public Optional<String> getReferenceCollectionCode(Integer referenceId) {
        return Optional.ofNullable(this.collectionCodeByReferenceId.get(referenceId));
    }

    @Override
    public int compareTo(DomainObjectImpl o) {
        return this.getId().compareTo(o.getId());
    }

    public static Integer getTmpId() {
        return ++tmpId * -1;
    }

    @Override
    public boolean isAttrSet(String code) {
        DomainAttribute attr = this.getAttribute(code);
        return attr != null && StringUtils.isNotBlank(attr.getRawValue());
    }

    public void removeChild(DomainObjectImpl child) {
        String collectionCode = child.getCollection().getCode();
        if (this.childrenByCollection.containsKey(collectionCode)) {
            this.childrenByCollection.get(collectionCode).remove(child);
        }
        String elementCode = DomainTokenResolver.resolveFullToken(collectionCode, child.getCode());
        this.childrenByToken.remove(elementCode);
        this.childCascadeRemove(collectionCode, child.getCode());
        this.realChildrenIds.remove(child.getId());
        if (this.referencesInCollections.get(collectionCode) != null) {
            this.referencesInCollections.get(collectionCode).remove(child.getId());
            this.collectionCodeByReferenceId.remove(child.getId());
        }
        this.children.remove(child);
    }

    public void reload(DomainObject child) {
        this.addChild((DomainObjectImpl)child);
        this.children.add((DomainObjectImpl)child);
    }

    public List<DomainObjectImpl> getNotRefChildren() {
        ArrayList<DomainObjectImpl> realChildren = new ArrayList<DomainObjectImpl>();
        for (DomainObjectImpl child : this.children) {
            if (!this.realChildrenIds.contains(child.getId())) continue;
            realChildren.add(child);
        }
        return realChildren;
    }

    public void addChildren(List<DomainObjectImpl> children) {
        for (DomainObjectImpl child : children) {
            this.reload(child);
        }
    }

    public String getFullPath() {
        String normalizedPath = this.normalizePath();
        return Objects.isNull(this.collection) ? null : StringUtils.substringBeforeLast(normalizedPath, "/") + "/" + DomainTokenResolver.resolveFullToken(this.collection.getCode(), this.code);
    }

    private String normalizePath() {
        String normalizedPath;
        String string = normalizedPath = this.getPath() == null ? "" : this.getPath();
        if (normalizedPath.endsWith("/")) {
            normalizedPath = StringUtils.substringBeforeLast(normalizedPath, "/");
        }
        return normalizedPath;
    }

    public void addTag(Tag tag) {
        this.tags.add(tag);
    }

    public String getCollectionCodeOrNull() {
        return this.collection != null ? this.collection.getCode() : null;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDynamicAttributes(List<DomainAttribute> dynamicAttributes) {
        this.dynamicAttributes = dynamicAttributes;
    }

    public Set<DomainObjectImpl> getChildren() {
        return this.children;
    }

    @Override
    public List<DomainAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public RegionCached getRegion() {
        return this.region;
    }

    public void setRegion(RegionCached region) {
        this.region = region;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setParent(DomainObjectImpl parent) {
        this.parent = parent;
    }

    public Integer getIdToSelectChildren() {
        return this.idToSelectChildren;
    }

    public void setIdToSelectChildren(Integer idToSelectChildren) {
        this.idToSelectChildren = idToSelectChildren;
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Integer sessionId) {
        this.sessionId = sessionId;
    }

    public boolean isHead() {
        return this.head;
    }

    public Integer getCopyFrom() {
        return this.copyFrom;
    }

    public void setCopyFrom(Integer copyFrom) {
        this.copyFrom = copyFrom;
    }

    public Map<String, List<Integer>> getReferencesInCollections() {
        return this.referencesInCollections;
    }

    public Map<String, Set<DomainObject>> getChildrenByCollection() {
        return this.childrenByCollection;
    }
}

