/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.model.proxy;

import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.model.DomainAttribute;
import io.higson.runtime.model.DomainObject;
import io.higson.runtime.model.DomainObjectType;
import io.higson.runtime.model.DomainTokenResolver;
import io.higson.runtime.model.RegionCached;
import io.higson.runtime.model.Tag;
import io.higson.runtime.model.proxy.DomainAttributeProxy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DomainObjectProxy
implements DomainObject {
    private final DomainObject obj;
    private final HigsonEngine engine;
    private final String profile;
    private final String callPath;

    @Override
    public DomainObject getDomain(String objectPath) {
        DomainObject childObj = this.obj.getDomain(objectPath);
        if (childObj == null) {
            return childObj;
        }
        String childPath = DomainObjectProxy.toPath(this.callPath, objectPath);
        return new DomainObjectProxy(childObj, this.engine, this.profile, childPath);
    }

    @Override
    public String getCode() {
        return this.obj.getCode();
    }

    @Override
    public String getName() {
        return this.obj.getName();
    }

    @Override
    public String getDescription() {
        return this.obj.getDescription();
    }

    @Override
    public String getTypeCode() {
        return this.obj.getTypeCode();
    }

    @Override
    public String getTypeName() {
        return this.obj.getTypeName();
    }

    @Override
    public String getPath() {
        return this.obj.getPath();
    }

    @Override
    public DomainAttribute getAttribute(String code) {
        return this.getProxy(this.obj.getAttribute(code));
    }

    @Override
    public boolean isAttrSet(String code) {
        return this.obj.isAttrSet(code);
    }

    @Override
    public List<DomainAttribute> getAttributes() {
        return this.getProxyAttributes(this.obj.getAttributes());
    }

    @Override
    public DomainAttribute getDynamicAttribute(String code) {
        return this.getProxy(this.obj.getDynamicAttribute(code));
    }

    @Override
    public Optional<DomainAttribute> getFromAllAttributes(String code) {
        return this.obj.getFromAllAttributes(code).map(attr -> new DomainAttributeProxy((DomainAttribute)attr, this));
    }

    @Override
    public List<DomainAttribute> getDynamicAttributes() {
        return this.getProxyAttributes(this.obj.getDynamicAttributes());
    }

    private List<DomainAttribute> getProxyAttributes(List<DomainAttribute> attrList) {
        ArrayList<DomainAttribute> proxyList = new ArrayList<DomainAttribute>(attrList.size());
        for (DomainAttribute attr : attrList) {
            proxyList.add(new DomainAttributeProxy(attr, this));
        }
        return proxyList;
    }

    @Override
    public DomainObject getChild(String propCode, String code) {
        DomainObject child = this.obj.getChild(propCode, code);
        if (child == null) {
            return null;
        }
        String childPath = DomainObjectProxy.toPath(this.callPath, DomainObjectProxy.toElement(propCode, code));
        return new DomainObjectProxy(child, this.engine, this.profile, childPath);
    }

    @Override
    public List<DomainObject> getChildren(String propCode) {
        List<DomainObject> children = this.obj.getChildren(propCode);
        if (children.isEmpty()) {
            return children;
        }
        ArrayList<DomainObject> proxyChildren = new ArrayList<DomainObject>(children.size());
        for (DomainObject child : children) {
            String childPath = DomainObjectProxy.toPath(this.callPath, DomainObjectProxy.toElement(propCode, child.getCode()));
            proxyChildren.add(new DomainObjectProxy(child, this.engine, this.profile, childPath));
        }
        return proxyChildren;
    }

    @Override
    public DomainObject getParent() {
        String parentPath = this.getParentPath();
        return this.getProxy(this.engine.getDomain(this.profile, parentPath), parentPath);
    }

    private DomainObject getProxy(DomainObject obj, String callPath) {
        return obj != null ? new DomainObjectProxy(obj, this.engine, this.profile, callPath) : null;
    }

    private DomainAttribute getProxy(DomainAttribute attr) {
        return attr != null ? new DomainAttributeProxy(attr, this) : null;
    }

    @Override
    public DomainAttribute getAttribute(String path, String attributeCode) {
        DomainAttribute attr = this.obj.getAttribute(path, attributeCode);
        return attr != null ? new DomainAttributeProxy(attr, this) : null;
    }

    @Override
    public ParamValue getAttributeValue(String path, String attributeCode, ParamContext ctx, Object ... args) {
        return this.obj.getAttributeValue(path, attributeCode, ctx, args);
    }

    @Override
    public boolean isRoot() {
        return this.obj.isRoot();
    }

    @Override
    public boolean isAttrDefined(String code) {
        return this.obj.isAttrDefined(code);
    }

    @Override
    public boolean isLocalAttr(String code) {
        return this.obj.isLocalAttr(code);
    }

    @Override
    public DomainAttribute getAttr(String code) {
        return this.getAttribute(code);
    }

    @Override
    public String getAttrString(String attrCode, HigsonContext ctx) {
        return this.obj.getAttrString(attrCode, ctx);
    }

    @Override
    public BigDecimal getAttrDecimal(String attrCode, HigsonContext ctx) {
        return this.obj.getAttrDecimal(attrCode, ctx);
    }

    @Override
    public double getAttrNumber(String attrCode, HigsonContext ctx) {
        return this.obj.getAttrNumber(attrCode, ctx);
    }

    @Override
    public Integer getAttrInteger(String attrCode, HigsonContext ctx) {
        return this.obj.getAttrInteger(attrCode, ctx);
    }

    @Override
    public Date getAttrDate(String attrCode, HigsonContext ctx) {
        return this.obj.getAttrDate(attrCode, ctx);
    }

    @Override
    public boolean getAttrBoolean(String attrCode, HigsonContext ctx) {
        return this.obj.getAttrBoolean(attrCode, ctx);
    }

    @Override
    public Integer getId() {
        return this.obj.getId();
    }

    @Override
    public Integer getParentId() {
        return this.obj.getParentId();
    }

    @Override
    public String getCallPath() {
        return this.callPath;
    }

    @Override
    public DomainObjectType getTypeCollection() {
        return this.obj.getTypeCollection();
    }

    @Override
    public RegionCached getRegion() {
        return this.obj.getRegion();
    }

    @Override
    public List<Tag> getTagList() {
        return this.obj.getTagList();
    }

    @Override
    public String getDigest() {
        return this.obj.getDigest();
    }

    public DomainObject unwrap() {
        return this.obj;
    }

    public static String toPath(String domainPath) {
        if (StringUtils.isBlank(domainPath)) {
            return "/";
        }
        Object path = domainPath.trim();
        if (((String)path).equals("/")) {
            return path;
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        return path;
    }

    public static String toPath(String path1, String path2) {
        String p1 = DomainObjectProxy.toPath(path1);
        String p2 = DomainObjectProxy.toPath(path2);
        if (p1.endsWith("/")) {
            p1 = p1.substring(0, p1.length() - 1);
        }
        return DomainObjectProxy.toPath(p1 + p2);
    }

    public static String toElement(String collectionCode, String elementCode) {
        return DomainTokenResolver.resolveFullToken(collectionCode, elementCode);
    }

    public static String rejectLastToken(String path) {
        int lastIx = path.lastIndexOf(47);
        if (lastIx >= 0) {
            return DomainObjectProxy.toPath(path.substring(0, lastIx));
        }
        return "/";
    }

    public String getParentPath() {
        return DomainObjectProxy.rejectLastToken(this.callPath);
    }

    public String toString() {
        return "HigsonDomainObjectProxy[id=" + this.getId() + ", parent=" + this.getParentId() + ", callPath=" + this.callPath + ", path=" + this.getPath() + ", profile=" + this.profile + "]";
    }

    public DomainObjectProxy(DomainObject obj, HigsonEngine engine, String profile2, String callPath) {
        this.obj = obj;
        this.engine = engine;
        this.profile = profile2;
        this.callPath = callPath;
    }
}

