/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler.engine;

import io.higson.runtime.profiler.attribute.AttributeKey;
import io.higson.runtime.profiler.attribute.AttributeProfiler;
import io.higson.runtime.profiler.attribute.AttributeStat;
import java.util.List;

public enum AttributeEngineProfiler {
    DOMAIN;

    private final transient AttributeProfiler invokeProfiler = new AttributeProfiler();
    private final transient AttributeProfiler loadProfiler = new AttributeProfiler();

    public void addLoadMeasure(AttributeKey key, long t1, long t2) {
        this.loadProfiler.addTime(key, t1, t2);
    }

    public void addInvokeMeasure(AttributeKey key, long t1, long t2) {
        this.invokeProfiler.addTime(key, t1, t2);
    }

    public AttributeProfiler getInvokeProfiler() {
        return this.invokeProfiler;
    }

    public AttributeProfiler getLoadProfiler() {
        return this.loadProfiler;
    }

    public List<AttributeStat> getLoadStats() {
        return this.loadProfiler.getStatistics();
    }

    public List<AttributeStat> getInvokeStats() {
        return this.invokeProfiler.getStatistics();
    }

    public AttributeStat getInvokeStat(AttributeKey key) {
        return this.getStat(key, this.invokeProfiler);
    }

    public AttributeStat getLoadStat(AttributeKey key) {
        return this.getStat(key, this.loadProfiler);
    }

    private AttributeStat getStat(AttributeKey key, AttributeProfiler profiler) {
        List stats = profiler.getStatistics();
        for (AttributeStat stat : stats) {
            if (!((AttributeKey)stat.getKey()).equals(key)) continue;
            return stat;
        }
        return new AttributeStat(key);
    }
}

