/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.reload;

import io.higson.runtime.prefetch.Initializer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncReloader {
    private static final Logger log = LoggerFactory.getLogger(AsyncReloader.class);
    private static final int DEFAULT_POOL_SIZE = 2;
    private static final int DEFAULT_QUEUE_SIZE = 256;
    private final Initializer parameterInitializer;
    private final ThreadPoolExecutor executor;

    public AsyncReloader(Initializer parameterInitializer, int poolSize) {
        this.parameterInitializer = parameterInitializer;
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(256), new ThreadPoolExecutor.DiscardPolicy());
    }

    public AsyncReloader(Initializer parameterInitializer) {
        this(parameterInitializer, 2);
    }

    public void submitToReload(String uid) {
        this.executor.submit(() -> this.reload(uid));
    }

    public void close() {
        log.info("closing reloader thread pool: {}", (Object)this.executor);
        this.executor.shutdown();
    }

    private void reload(String uid) {
        this.parameterInitializer.initialize(uid);
    }

    public String toString() {
        return "AsyncReloader[" + this.executor + "]";
    }
}

