/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.rhino.value;

import io.higson.runtime.core.EmptyParamValue;
import io.higson.runtime.engine.core.exception.SmartParamException;
import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.output.ParamValueImpl;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.util.Formatter;
import io.higson.runtime.engine.util.Printer;
import io.higson.runtime.rhino.value.RhinoMultiValue;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class RhinoParamValue {
    private final RhinoMultiValue[] rows;

    public RhinoParamValue(ParamValue value) {
        int size = value.size();
        this.rows = new RhinoMultiValue[size];
        for (int i = 0; i < size; ++i) {
            this.rows[i] = new RhinoMultiValue(value.row(i));
        }
    }

    public RhinoParamValue() {
        this.rows = new RhinoMultiValue[0];
    }

    public RhinoMultiValue row(int rowNo) {
        if (rowNo >= 0 && rowNo < this.size()) {
            return this.rows[rowNo];
        }
        throw new InvalidRowIndexException(rowNo, this.rows);
    }

    public RhinoMultiValue row() {
        return this.row(0);
    }

    public List<RhinoMultiValue> rows() {
        return Arrays.asList(this.rows);
    }

    public Iterator<RhinoMultiValue> iterator() {
        return this.rows().iterator();
    }

    public <T> T get(int rowNo, int colNo) {
        return this.row(rowNo).get(colNo);
    }

    public <T> T get(int rowNo, int colNo, Class<T> clazz) {
        return this.row(rowNo).get(colNo, clazz);
    }

    public <T> T get(int rowNo, String name) {
        return this.row(rowNo).get(name);
    }

    public <T> T get(int rowNo, String name, Class<T> clazz) {
        return this.row(rowNo).get(name, clazz);
    }

    public <T> T get(int colNo) {
        return this.row().get(colNo);
    }

    public <T> T get(int colNo, Class<T> clazz) {
        return this.row().get(colNo, clazz);
    }

    public <T> T get(String name) {
        return this.row().get(name);
    }

    public <T> T get() {
        return this.row().get(0);
    }

    public <T> T get(String name, Class<T> clazz) {
        return this.row().get(name, clazz);
    }

    public ValueHolder getHolder(String name) {
        return this.row().getHolder(name);
    }

    public ValueHolder getHolder(int colNo) {
        return this.row().getHolder(colNo);
    }

    public ValueHolder getHolder(int rowNo, String name) {
        return this.row(rowNo).getHolder(name);
    }

    public ValueHolder getHolder(int rowNo, int colNo) {
        return this.row(rowNo).getHolder(colNo);
    }

    public ValueHolder getHolder() {
        return this.row().getHolder(0);
    }

    public double getNumber(String name) {
        return this.row().getNumber(name);
    }

    public double getNumber(int position) {
        return this.row().getNumber(position);
    }

    public double getNumber() {
        return this.row().getNumber(0);
    }

    public BigDecimal getDecimal(String name) {
        return this.row().getDecimal(name);
    }

    public BigDecimal getDecimal(int position) {
        return this.row().getDecimal(position);
    }

    public BigDecimal getDecimal() {
        return this.getDecimal(0);
    }

    public BigDecimal getBigDecimal(String name) {
        return this.row().getBigDecimal(name);
    }

    public BigDecimal getBigDecimal(int position) {
        return this.row().getBigDecimal(position);
    }

    public BigDecimal getBigDecimal() {
        return this.getBigDecimal(0);
    }

    public Integer getInteger(String name) {
        return this.row().getInteger(name);
    }

    public Integer getInteger(int position) {
        return this.row().getInteger(position);
    }

    public Integer getInteger() {
        return this.getInteger(0);
    }

    public Long getLong(String name) {
        return this.row().getLong(name);
    }

    public Long getLong(int position) {
        return this.row().getLong(position);
    }

    public Long getLong() {
        return this.getLong(0);
    }

    public Date getDate(String name) {
        return this.row().getDate(name);
    }

    public Date getDate(int position) {
        return this.row().getDate(position);
    }

    public Date getDate() {
        return this.getDate(0);
    }

    public String getString(String name) {
        return this.row().getString(name);
    }

    public String getString(int position) {
        return this.row().getString(position);
    }

    public String getString() {
        return this.getString(0);
    }

    public boolean getBoolean(String name) {
        return this.row().getBoolean(name);
    }

    public boolean getBoolean(int position) {
        return this.row().getBoolean(position);
    }

    public boolean getBoolean() {
        return this.getBoolean(0);
    }

    public int size() {
        return this.rows != null ? this.rows.length : 0;
    }

    public ParamValue unwrap() {
        if (this.size() == 0) {
            return new EmptyParamValue();
        }
        MultiValue[] matrix = new MultiValue[this.size()];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = this.row(i).raw();
        }
        return new ParamValueImpl(matrix);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isBlank() {
        for (RhinoMultiValue row : this.rows) {
            if (row.isBlank()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Printer.print(Arrays.asList(this.rows), "RParamValue", 0, new MultiValueInlineFormatter());
    }

    static final class InvalidRowIndexException
    extends SmartParamException {
        InvalidRowIndexException(int rowIndex, Object[] values) {
            super("INVALID_ROW_INDEX", String.format("Trying to get non-existing row: %d. Available rows: %d..%d", rowIndex, 0, values.length - 1));
        }
    }

    static final class MultiValueInlineFormatter
    implements Formatter {
        MultiValueInlineFormatter() {
        }

        @Override
        public String format(Object obj) {
            RhinoMultiValue mv = (RhinoMultiValue)obj;
            return mv.toStringInline();
        }
    }
}

