/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.utils;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Messages {
    private static final String BUNDLE_NAME = "io.higson.runtime.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("io.higson.runtime.messages");
    private static final Logger LOG = LoggerFactory.getLogger(Messages.class);

    private Messages() {
    }

    private static String getMessageFromBundle(String key, ResourceBundle bundle) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            LOG.trace("missing resource", e);
            return "!" + key + "!";
        }
    }

    public static String message(String key, Object ... params) {
        try {
            return MessageFormat.format(RESOURCE_BUNDLE.getString(key), params);
        }
        catch (MissingResourceException e) {
            LOG.trace("missing resource", e);
            return "!" + key + "!";
        }
    }

    public static String message(String key) {
        return Messages.getMessageFromBundle(key, RESOURCE_BUNDLE);
    }
}

