/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.util.reflection;

import eu.infomas.annotation.AnnotationDetector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.smartparam.engine.util.reflection.AnnotatedMethodReporter;
import org.smartparam.engine.util.reflection.AnnotatedTypeReporter;
import org.smartparam.engine.util.reflection.AnnotationScannerException;

public class ReflectionsScanner {
    public Set<Class<?>> findClassesAnnotatedWith(Class<? extends Annotation> annotationType, List<String> packagesToScan) {
        String[] packagesArray = this.convertPackagesToArray(packagesToScan);
        AnnotatedTypeReporter typeReporter = new AnnotatedTypeReporter(annotationType, packagesArray);
        this.runDetector(typeReporter, packagesArray);
        return typeReporter.getAnnotatedClasses();
    }

    public Set<Method> findMethodsAnnotatedWith(Class<? extends Annotation> annotationType, List<String> packagesToScan) {
        String[] packagesArray = this.convertPackagesToArray(packagesToScan);
        AnnotatedMethodReporter methodReporter = new AnnotatedMethodReporter(annotationType, packagesArray);
        this.runDetector(methodReporter, packagesArray);
        return methodReporter.getAnnotatedMethods();
    }

    private void runDetector(AnnotationDetector.Reporter reporter, String ... packagesToScan) {
        try {
            AnnotationDetector detector = new AnnotationDetector(reporter);
            detector.detect(packagesToScan);
        }
        catch (IOException exception) {
            throw new AnnotationScannerException(exception, packagesToScan);
        }
    }

    private String[] convertPackagesToArray(List<String> packagesToScan) {
        return packagesToScan.toArray(new String[0]);
    }
}

