/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.common.security.SystemRoleManagementService;
import pl.decerto.hyperon.common.security.SystemUserValidator;
import pl.decerto.hyperon.common.security.UserManagementService;
import pl.decerto.hyperon.common.security.domain.UserStatus;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.dto.SystemUser;

public abstract class AbstractExternalSystemUserCreator<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractExternalSystemUserCreator.class);
    private final SystemUserValidator systemUserValidator;
    private final UserManagementService userManagementService;
    private final SystemRoleManagementService systemRoleManagementService;

    public SystemUser createOrUpdate(String login, T userInfoObj) {
        return this.userManagementService.getUserByLoginWithIgnoreCase(login).map(user -> this.update(login, (SystemUser)user, userInfoObj)).orElseGet(() -> this.create(login, userInfoObj));
    }

    protected abstract String[] getRoles(T var1);

    protected abstract String getFirstName(T var1);

    protected abstract String getLastName(T var1);

    protected abstract String getEmail(T var1);

    protected abstract boolean isExternalRolesOrigin();

    private SystemUser create(String login, T userInfo) {
        log.info("Creating new external user in Higson Studio with login {}.", (Object)login);
        SystemUser systemUser = new SystemUser();
        this.setUserFields(login, systemUser, userInfo);
        this.userManagementService.add(systemUser, false);
        return systemUser;
    }

    private SystemUser update(String login, SystemUser systemUser, T userInfo) {
        log.debug("Updating external systemUser {}. Login {}.", (Object)systemUser.getLogin(), (Object)login);
        this.setUserFields(login, systemUser, userInfo);
        this.userManagementService.modify(systemUser);
        return systemUser;
    }

    private void setUserFields(String login, SystemUser systemUser, T userInfo) {
        systemUser.setStatus(UserStatus.EXTERNAL);
        systemUser.setLogin(login);
        systemUser.setFirstName(this.getFirstName(userInfo));
        systemUser.setLastName(this.getLastName(userInfo));
        systemUser.setEmail(this.getEmail(userInfo));
        this.systemUserValidator.validate(systemUser);
        if (this.isExternalRolesOrigin()) {
            this.setRoles(systemUser, userInfo);
        }
    }

    private void setRoles(SystemUser systemUser, T userInfo) {
        log.debug("Clearing all roles for systemUser {}.", (Object)systemUser.getLogin());
        systemUser.getRoles().clear();
        Object[] roles = this.getRoles(userInfo);
        if (ArrayUtils.isEmpty(roles)) {
            log.debug("No roles sent from external authentication provider for systemUser {}.", (Object)systemUser.getLogin());
            return;
        }
        for (Object role : roles) {
            this.setRole(systemUser, (String)role);
        }
    }

    private void setRole(SystemUser systemUser, String role) {
        log.debug("Trying to set role {} for systemUser {}.", (Object)role, (Object)systemUser.getLogin());
        SystemRole systemRole = this.systemRoleManagementService.getRoleByCode(role);
        if (Objects.isNull(systemRole)) {
            log.debug("Role {} not found in Higson Studio.", (Object)role);
            return;
        }
        log.debug("Role {} found in Higson Studio, setting for systemUser {}.", (Object)role, (Object)systemUser.getLogin());
        systemUser.addRole(systemRole);
    }

    public AbstractExternalSystemUserCreator(SystemUserValidator systemUserValidator, UserManagementService userManagementService, SystemRoleManagementService systemRoleManagementService) {
        this.systemUserValidator = systemUserValidator;
        this.userManagementService = userManagementService;
        this.systemRoleManagementService = systemRoleManagementService;
    }
}

