/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import io.higson.runtime.exception.HigsonIllegalStateException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.decerto.hyperon.common.security.SystemRoleManagementService;
import pl.decerto.hyperon.common.security.UserManagementMappers;
import pl.decerto.hyperon.common.security.UserManagementService;
import pl.decerto.hyperon.common.security.cache.UserCacheEntry;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.dao.ResetPasswordDao;
import pl.decerto.hyperon.common.security.dao.SystemUserPreferenceJPADao;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;
import pl.decerto.hyperon.common.security.domain.PasswordStatus;
import pl.decerto.hyperon.common.security.domain.ResetPasswordMailType;
import pl.decerto.hyperon.common.security.domain.ResetPasswordStatus;
import pl.decerto.hyperon.common.security.domain.ResetPasswordToken;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserPreferenceJPA;
import pl.decerto.hyperon.common.security.domain.UserStatus;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.dto.SystemUserPreference;

@Service
public class UserManagementServiceImpl
implements UserManagementService {
    private static final Logger log = LoggerFactory.getLogger(UserManagementServiceImpl.class);
    private final UserManagementDao dao;
    private final SystemUserPreferenceJPADao prefDao;
    private final ResetPasswordDao resetPasswordDao;
    private final UsersCacheManager userCache;
    private final UserManagementMappers userManagementMappers;
    private final SystemRoleManagementService systemRoleManagementService;
    private final PasswordEncoder passwordEncoder;
    private final EntityManager entityManager;

    @Override
    @Transactional(readOnly=true)
    public List<SystemUser> getUsers() {
        log.debug("fetching all users");
        return this.dao.findAll().stream().map(this.userManagementMappers::fullUserToDto).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly=true)
    public SystemUser getUserByLogin(String login) {
        SystemUserJPA user = this.dao.findByLogin(login);
        return this.convertUser(user);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<SystemUser> getUserByLoginWithIgnoreCase(String login) {
        Optional<SystemUserJPA> user = this.dao.findByLoginWithIgnoreCase(login.toLowerCase());
        return user.map(this::convertUser);
    }

    @Override
    @Transactional(readOnly=true)
    public SystemUser getUserByEmail(String email) {
        SystemUserJPA user = this.dao.findByEmail(email.toLowerCase());
        return this.convertUser(user);
    }

    private SystemUser convertUser(SystemUserJPA user) {
        if (user == null) {
            return null;
        }
        if (!user.getPreferences().isEmpty()) {
            user.getPreferences().iterator().next();
        }
        if (!user.getRoles().isEmpty()) {
            user.getRoles().iterator().next();
        }
        log.info("user fetched: {}", (Object)user);
        return this.userManagementMappers.fullUserToDto(user);
    }

    @Override
    public Optional<SystemUser> getUserByLoginCommonData(String login) {
        return Optional.ofNullable(this.dao.findByLogin(login)).map(user -> {
            log.info("user fetched: {}", user);
            return this.userManagementMappers.simpleUserToDto((SystemUserJPA)user);
        });
    }

    @Override
    public String passwordEncode(String plaintText) {
        return this.passwordEncoder.encode((CharSequence)plaintText);
    }

    @Override
    public boolean isPasswordMatching(String plainText, SystemUser user) {
        return this.passwordEncoder.matches((CharSequence)plainText, user.getPassword());
    }

    @Override
    @Transactional
    public void add(SystemUser dto, boolean encodePassword) {
        log.info("creating user: {}", (Object)dto.getLogin());
        SystemUserJPA newUser = this.userManagementMappers.fullUserToModel(dto);
        newUser.setCreateDate(new Date());
        if (newUser.getStatus() == null) {
            newUser.setStatus(UserStatus.ACTIVE);
        }
        if (encodePassword) {
            newUser.setPassword(this.passwordEncoder.encode((CharSequence)dto.getPassword()));
        }
        this.dao.save(newUser);
        dto.setId(newUser.getId());
        dto.setCreateDate(newUser.getCreateDate());
        dto.setStatus(newUser.getStatus());
        this.entityManager.flush();
    }

    @Override
    @Transactional
    public void modify(SystemUser dto) {
        log.info("modifying user: {} id: {}", (Object)dto.getLogin(), (Object)dto.getId());
        SystemUserJPA model = this.getSystemUser(dto.getId());
        model.setLogin(dto.getLogin());
        model.setFirstName(dto.getFirstName());
        model.setLastName(dto.getLastName());
        model.setEmail(dto.getEmail());
        model.setCreateDate(dto.getCreateDate());
        model.setStatus(dto.getStatus());
        model.getRoles().clear();
        this.entityManager.flush();
        model.onUpdate();
        for (SystemRole role : dto.getRoles()) {
            model.addRole(this.userManagementMappers.simpleRoleToModel(role));
        }
        model.getPreferences().clear();
        for (SystemUserPreference preference : dto.getPreferences()) {
            model.addPreference(this.userManagementMappers.simplePreferenceToModel(preference));
        }
        this.dao.save(model);
    }

    @Override
    @Transactional(readOnly=true)
    public SystemUser getUser(Integer id) {
        log.debug("user for id: {}", (Object)id);
        return this.dao.findById(id).map(this.userManagementMappers::fullUserToDto).orElse(null);
    }

    @Override
    @Transactional
    public void changePassword(Integer userId, String newPassword, boolean encode, PasswordStatus passwordStatus) {
        log.info("changing password for user with id: {}", (Object)userId);
        SystemUserJPA model = this.getSystemUser(userId);
        model.setPasswordStatus(passwordStatus);
        if (encode) {
            model.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
        } else {
            model.setPassword(newPassword);
        }
    }

    public SystemUserJPA getSystemUser(Integer userId) {
        return (SystemUserJPA)this.dao.findById(userId).orElseThrow(() -> new HigsonIllegalStateException("Missing system user with id: " + userId));
    }

    @Override
    @Transactional
    public void addOrUpdateResetPasswordToken(String userEmail, ResetPasswordMailType mailType) {
        log.info("adding or updating password token for email: {}", (Object)userEmail);
        this.addOrUpdateResetPasswordToken(userEmail, ResetPasswordStatus.NEW, mailType);
    }

    @Override
    @Transactional
    @Nullable
    public String addActiveResetPasswordTokenIfPasswordGenerated(String userEmail) {
        SystemUser userByEmail = this.getUserByEmail(userEmail);
        if (userByEmail != null && userByEmail.getPasswordStatus() == PasswordStatus.GENERATED) {
            log.info("adding or updating password active token for email: {}", (Object)userEmail);
            return this.addOrUpdateResetPasswordToken(userEmail, ResetPasswordStatus.ACTIVE, ResetPasswordMailType.RESET_PASSWORD);
        }
        return null;
    }

    private String addOrUpdateResetPasswordToken(String userEmail, ResetPasswordStatus status, ResetPasswordMailType mailType) {
        ResetPasswordToken token = this.resetPasswordDao.findByEmail(userEmail);
        if (token == null) {
            log.debug("token not found - creating new token for email: {}", (Object)userEmail);
            token = new ResetPasswordToken();
            token.setEmail(userEmail);
        }
        token.setToken(this.generateToken());
        token.setStatus(status);
        token.setEmailType(mailType);
        this.resetPasswordDao.save(token);
        return token.getToken();
    }

    private String generateToken() {
        return UUID.randomUUID().toString();
    }

    @Override
    @Transactional(readOnly=true)
    public ResetPasswordToken getPasswordTokenByEmail(String email) {
        log.debug("getting token for email: {}", (Object)email);
        return this.resetPasswordDao.findByEmail(email);
    }

    @Override
    @Transactional(readOnly=true)
    public SystemUser getUserByPasswordToken(String tokenValue) {
        ResetPasswordToken token = this.resetPasswordDao.findByTokenAndStatus(tokenValue, ResetPasswordStatus.ACTIVE);
        return token == null ? null : this.getUserByEmail(token.getEmail());
    }

    @Override
    @Transactional
    public void persistPasswordToken(ResetPasswordToken token) {
        log.info("saving password token for email: {}", (Object)token.getEmail());
        this.resetPasswordDao.save(token);
    }

    @Override
    @Transactional
    public void removeRoleFromUsers(List<SystemUser> users, SystemRole role) {
        log.info("removing role {} from {} users", (Object)role.getCode(), (Object)users.size());
        SystemRole systemRoleFromDB = this.systemRoleManagementService.getRoleByCode(role.getCode());
        SystemRoleJPA roleJPA = this.userManagementMappers.complexRoleToModel(systemRoleFromDB);
        Collection<SystemUserJPA> usersFromBase = this.refreshUsers(users);
        for (SystemUserJPA nextUser : usersFromBase) {
            nextUser.getRoles().remove(roleJPA);
            nextUser.onUpdate();
        }
        this.dao.saveAll(usersFromBase);
    }

    private Collection<SystemUserJPA> refreshUsers(List<SystemUser> users) {
        List usersIds = users.stream().map(SystemUser::getId).collect(Collectors.toList());
        List ret = this.dao.findAllById(usersIds);
        log.debug("found {} users", (Object)users.size());
        return ret;
    }

    @Override
    @Transactional
    public void addRoleToUsers(List<SystemUser> users, SystemRole role) {
        log.info("adding role {} to {} users", (Object)role.getCode(), (Object)users.size());
        SystemRoleJPA roleJPA = this.userManagementMappers.complexRoleToModel(role);
        this.refreshUsers(users).forEach(user -> {
            user.addRole(roleJPA);
            user.onUpdate();
            this.dao.saveAndFlush(user);
        });
    }

    @Override
    @Transactional(readOnly=true)
    public List<ResetPasswordToken> getPasswordTokensByStatus(ResetPasswordStatus status) {
        log.trace("fetching password tokens for status {}", (Object)status);
        List<ResetPasswordToken> ret = this.resetPasswordDao.findAllByStatus(status);
        log.trace("found {} password tokens for status {}", (Object)ret.size(), (Object)status);
        return ret;
    }

    @Override
    @Transactional
    public SystemUser modifyOrCreateSystemUserPreference(String login, String userPreference, String value) {
        return this.getUserByLoginCommonData(login).map(user -> this.modifyOrCreateSystemUserPreference((SystemUser)user, userPreference, value)).orElse(null);
    }

    @Override
    @Transactional
    public SystemUser modifyOrCreateSystemUserPreference(SystemUser user, String userPreference, String value) {
        if (user != null) {
            boolean found;
            boolean bl = found = !this.prefDao.findValue(user.getId(), userPreference.trim()).isEmpty();
            if (!found) {
                this.createNewPreference(user, userPreference, value);
            } else {
                this.prefDao.updateValue(user.getId(), userPreference.trim(), StringUtils.trim(value));
                this.userCache.reloadPreferences(user.getLogin());
            }
        } else {
            log.warn("user is null - aborting");
        }
        return user;
    }

    private void createNewPreference(SystemUser user, String userPreference, String value) {
        log.debug("creating new preference {} with value {} for user {}", userPreference, value, user.getLogin());
        SystemUserPreferenceJPA pref = new SystemUserPreferenceJPA();
        pref.setKey(userPreference.trim());
        pref.setValue(value.trim());
        SystemUserJPA userJPA = new SystemUserJPA();
        userJPA.setId(user.getId());
        pref.setUser(userJPA);
        this.prefDao.save(pref);
        this.userCache.addPreference(user.getLogin(), userPreference, value);
    }

    @Override
    @Transactional
    public void importUser(SystemUser newUser) {
        log.debug("enter importUser({})", (Object)newUser);
        SystemUserJPA oldUser = this.dao.findByLogin(newUser.getLogin());
        if (oldUser == null) {
            log.debug("Adding imported user {}", (Object)newUser);
            this.add(newUser, false);
        } else {
            if (!newUser.nothingChanged(this.userManagementMappers.fullUserToDto(oldUser))) {
                newUser.setId(oldUser.getId());
                newUser.setCreateDate(oldUser.getCreateDate());
                this.modify(newUser);
                if (!oldUser.getPassword().equals(newUser.getPassword())) {
                    this.changePassword(oldUser.getId(), newUser.getPassword(), false, PasswordStatus.SET);
                }
                log.debug("Updating imported user {}", (Object)newUser);
            }
            log.debug("No changes for imported user {}", (Object)newUser);
        }
    }

    @Override
    public List<String> getUsersToFilter() {
        return this.dao.getLogins(UserStatus.ACTIVE);
    }

    @Override
    @Transactional
    public SystemUser removeSystemUserPreference(String username, String propertyKey, String value) {
        return this.getUserByLoginCommonData(username).map(user -> {
            this.removeUserPreference((SystemUser)user, username, propertyKey);
            return user;
        }).orElse(null);
    }

    private void removeUserPreference(SystemUser user, String username, String propertyKey) {
        boolean found;
        boolean bl = found = !this.prefDao.findValue(user.getId(), propertyKey).isEmpty();
        if (found) {
            log.debug("removing preference {} for user {}", (Object)propertyKey, (Object)user.getLogin());
            this.prefDao.removePreference(user.getId(), propertyKey);
            this.userCache.reloadPreferences(username);
        }
    }

    @Override
    public UserCacheEntry getUserCacheEntry(String login) {
        return this.userCache.getUserCacheEntry(login);
    }

    public UserManagementServiceImpl(UserManagementDao dao, SystemUserPreferenceJPADao prefDao, ResetPasswordDao resetPasswordDao, UsersCacheManager userCache, UserManagementMappers userManagementMappers, SystemRoleManagementService systemRoleManagementService, PasswordEncoder passwordEncoder, EntityManager entityManager) {
        this.dao = dao;
        this.prefDao = prefDao;
        this.resetPasswordDao = resetPasswordDao;
        this.userCache = userCache;
        this.userManagementMappers = userManagementMappers;
        this.systemRoleManagementService = systemRoleManagementService;
        this.passwordEncoder = passwordEncoder;
        this.entityManager = entityManager;
    }
}

