/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.activedirectory;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;
import org.springframework.transaction.annotation.Transactional;
import pl.decerto.hyperon.common.security.MppUserDetails;
import pl.decerto.hyperon.common.security.SystemRoleManagementService;
import pl.decerto.hyperon.common.security.UserDetailsAdditionalHolder;
import pl.decerto.hyperon.common.security.UserManagementService;
import pl.decerto.hyperon.common.security.activedirectory.ActiveDirectoryUserDetailsValidator;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.domain.PasswordStatus;
import pl.decerto.hyperon.common.security.domain.UserStatus;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.dto.SystemUser;

public class ActiveDirectoryUserDetailsMapper
extends LdapUserDetailsMapper {
    private static final int INDEX_OF_ROLE_FIRST_CHAR = 3;
    private static final char COMMA_CHAR = ',';
    private static final String DEFAULT_EMAIL_REPRESENTATION = "@local.com";
    private static final String FIRST_NAME_ATTRIBUTE_FROM_AD = "givenName";
    private static final String LAST_NAME_ATTRIBUTE_FROM_AD = "sn";
    private static final String EMAIL_ATTRIBUTE_FROM_AD = "mail";
    private static final String ROLES_ATTRIBUTE_FROM_AD = "memberOf";
    private final UsersCacheManager userCache;
    private final UserManagementService userService;
    private final SystemRoleManagementService roleService;
    private final ActiveDirectoryUserDetailsValidator activeDirectoryUserDetailsValidator;

    public ActiveDirectoryUserDetailsMapper(UserManagementService userService, SystemRoleManagementService roleService, UsersCacheManager userCache, ActiveDirectoryUserDetailsValidator activeDirectoryUserDetailsValidator) {
        this.userCache = userCache;
        this.userService = userService;
        this.roleService = roleService;
        this.activeDirectoryUserDetailsValidator = activeDirectoryUserDetailsValidator;
    }

    @Transactional
    public MppUserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        UserDetails details = super.mapUserFromContext(ctx, username, authorities);
        UserDetailsAdditionalHolder userDetailsAdditionalHolder = this.createUserDetailsAdditionalHolder(details);
        this.activeDirectoryUserDetailsValidator.validateUserDetailsHolder(userDetailsAdditionalHolder);
        String login = details.getUsername().toLowerCase();
        SystemUser user = this.getUser(ctx, login);
        return MppUserDetails.createMppUserDetailsWithAdditionalDetails(user, this.userCache.getUserCacheEntry(login), userDetailsAdditionalHolder);
    }

    private UserDetailsAdditionalHolder createUserDetailsAdditionalHolder(UserDetails details) {
        return new UserDetailsAdditionalHolder(details.isAccountNonExpired(), details.isAccountNonLocked(), details.isCredentialsNonExpired(), details.isEnabled());
    }

    private SystemUser getUser(DirContextOperations ctx, String login) {
        Optional<SystemUser> user = this.userService.getUserByLoginWithIgnoreCase(login);
        return user.map(systemUser -> this.updateExistingSystemUser(ctx, (SystemUser)systemUser, login)).orElseGet(() -> this.createNewSystemUser(ctx, login));
    }

    private SystemUser createNewSystemUser(DirContextOperations ctx, String login) {
        SystemUser tempUser = this.createUser(ctx, login);
        this.addUserToDB(tempUser);
        return tempUser;
    }

    private SystemUser updateExistingSystemUser(DirContextOperations ctx, SystemUser user, String login) {
        SystemUser tempUser = this.createUser(ctx, login);
        if (this.activeDirectoryUserDetailsValidator.isValidToUpdate(user, tempUser)) {
            tempUser.setId(user.getId());
            tempUser.setCreateDate(user.getCreateDate());
            this.addUserToDB(tempUser);
            user = tempUser;
        }
        return user;
    }

    private void addUserToDB(SystemUser systemUser) {
        if (this.activeDirectoryUserDetailsValidator.validateUser(systemUser)) {
            this.userService.add(systemUser, false);
        }
    }

    private SystemUser createUser(DirContextOperations ctx, String login) {
        SystemUser user = this.createUserDto(ctx, login);
        return this.getUserWithAssignedRoles(user, ctx);
    }

    private SystemUser createUserDto(DirContextOperations contextOperations, String login) {
        SystemUser user = new SystemUser();
        user.setLogin(login);
        user.setFirstName(contextOperations.getStringAttribute(FIRST_NAME_ATTRIBUTE_FROM_AD));
        user.setLastName(contextOperations.getStringAttribute(LAST_NAME_ATTRIBUTE_FROM_AD));
        user.setEmail(this.getEmail(contextOperations, login));
        user.setStatus(UserStatus.EXTERNAL);
        user.setPasswordStatus(PasswordStatus.SET);
        return user;
    }

    private String getEmail(DirContextOperations contextOperations, String login) {
        String emailFromCtx = contextOperations.getStringAttribute(EMAIL_ATTRIBUTE_FROM_AD);
        return StringUtils.isBlank(emailFromCtx) ? this.generateDefaultEmail(login) : emailFromCtx;
    }

    private String generateDefaultEmail(String login) {
        return login + DEFAULT_EMAIL_REPRESENTATION;
    }

    private SystemUser getUserWithAssignedRoles(SystemUser user, DirContextOperations ctx) {
        String[] rolesAttributes = ctx.getStringAttributes(ROLES_ATTRIBUTE_FROM_AD);
        if (this.activeDirectoryUserDetailsValidator.validateUserRoles(rolesAttributes)) {
            for (String roleAttribute : rolesAttributes) {
                this.addRoleToUser(user, roleAttribute);
            }
        }
        return user;
    }

    private void addRoleToUser(SystemUser user, String roleAttribute) {
        String role = this.getRoleNameFromADAttribute(roleAttribute);
        SystemRole systemRole = this.roleService.getRoleByCode(role);
        if (Objects.nonNull(systemRole)) {
            user.addRole(systemRole);
        }
    }

    private String getRoleNameFromADAttribute(String role) {
        return role.substring(3, role.indexOf(44));
    }
}

