/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.ext.adapter;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import pl.decerto.hyperon.ext.adapter.Adapter;
import pl.decerto.hyperon.ext.adapter.AdapterFactory;
import pl.decerto.hyperon.ext.adapter.AdapterFactoryImpl;
import pl.decerto.hyperon.runtime.core.HyperonSubContext;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public class CollectionAdapter<E>
implements Iterable<HyperonSubContext> {
    private final Collection<E> collection;
    private final AdapterFactory<E> factory;

    public CollectionAdapter(Collection<E> collection, AdapterFactory<E> factory) {
        this.collection = this.notnull(collection);
        this.factory = factory;
    }

    public <A extends Adapter> CollectionAdapter(Collection<E> collection, Class<A> adapterClass) {
        this.collection = this.notnull(collection);
        this.factory = new AdapterFactoryImpl(adapterClass);
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    public Iterator<HyperonSubContext> iterator() {
        return new Iterator<HyperonSubContext>(){
            private Iterator<E> it;
            {
                this.it = CollectionAdapter.this.collection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public HyperonSubContext next() {
                Object e = this.it.next();
                return CollectionAdapter.this.factory.create(e);
            }

            @Override
            public void remove() {
                throw new HyperonRuntimeException("Illegal operation");
            }
        };
    }

    private Collection<E> notnull(Collection<E> coll) {
        return coll != null ? coll : Collections.emptyList();
    }
}

