/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.cache.UserRegionVersionProvider;
import pl.decerto.hyperon.runtime.core.domain.AttributeValueProvider;
import pl.decerto.hyperon.runtime.core.domain.CacheKey;
import pl.decerto.hyperon.runtime.core.domain.SessionIdBuilder;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionResolver;
import pl.decerto.hyperon.runtime.dao.DomainCacheJdbcDao;
import pl.decerto.hyperon.runtime.model.DomainAttributeDto;
import pl.decerto.hyperon.runtime.model.DomainTokenResolver;
import pl.decerto.hyperon.runtime.model.HyperonDomainAttribute;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectImpl;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectType;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectTypeImpl;
import pl.decerto.hyperon.runtime.model.OpenSession;
import pl.decerto.hyperon.runtime.model.ReferenceDto;
import pl.decerto.hyperon.runtime.model.RegionCached;
import pl.decerto.hyperon.runtime.model.RegionVersion;
import pl.decerto.hyperon.runtime.model.TreeDomain;

public class MpDomainCacheProvider {
    private static final Logger log = LoggerFactory.getLogger(MpDomainCacheProvider.class);
    private static final int HEAD_ELEMENTS_IDENTIFIER = -1;
    private final DomainCacheJdbcDao dao;
    private final EffectiveVersionResolver effectiveVersionResolver;
    private final UserRegionVersionProvider userRegionVersionProvider;
    private AttributeValueProvider valueProvider;

    public MpDomainCacheProvider(DomainCacheJdbcDao dao, EffectiveVersionResolver effectiveVersionResolver, UserRegionVersionProvider userRegionVersionProvider) {
        this(dao, effectiveVersionResolver, userRegionVersionProvider, null);
    }

    public MpDomainCacheProvider(DomainCacheJdbcDao dao, EffectiveVersionResolver effectiveVersionResolver, UserRegionVersionProvider userRegionVersionProvider, AttributeValueProvider valueProvider) {
        this.dao = dao;
        this.valueProvider = valueProvider;
        this.effectiveVersionResolver = effectiveVersionResolver;
        this.userRegionVersionProvider = userRegionVersionProvider;
    }

    public void setAttributeValueProvider(AttributeValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public TreeDomain createDomainTree(String profileCode, EffectiveVersionConfiguration configuration) {
        return this.createDomainTree(profileCode, configuration, Collections.emptySet());
    }

    public TreeDomain createDomainTree(String profileCode, EffectiveVersionConfiguration configuration, Set<RegionVersion> userVersions) {
        log.trace("creating domain tree for profile:{} using version configuration:{}", (Object)profileCode, (Object)configuration);
        Set<Integer> userRegionVersionIds = this.effectiveVersionResolver.getEffectiveVersionIds(profileCode, configuration, userVersions);
        return this.createTreeFor(profileCode, -1, userRegionVersionIds);
    }

    public Map<CacheKey, TreeDomain> createTrees(String profile2, String user, EffectiveVersionConfiguration configuration) {
        Set<Integer> userRegionVersions;
        log.trace("entering createTrees(profile={},user={}, configuration={})", profile2, user, configuration);
        HashMap<CacheKey, TreeDomain> result = new HashMap<CacheKey, TreeDomain>();
        List<OpenSession> sessions = this.getOpenSessionsForUser(profile2, user);
        if (!sessions.isEmpty()) {
            log.trace("creating tree domain for active session");
        }
        for (OpenSession session : sessions) {
            userRegionVersions = this.getRegionVersionsForUser(profile2, session.getUserName(), configuration);
            TreeDomain tree = this.createTreeFor(profile2, session.getId(), userRegionVersions);
            log.trace("creating cacheKey for userRegionVersions: {}", (Object)userRegionVersions);
            CacheKey cacheKey = this.createCacheKeyByVersions(session.getUserName(), profile2, userRegionVersions);
            log.trace("active session. Created cacheKey: {}", (Object)cacheKey);
            result.put(cacheKey, tree);
        }
        if (sessions.isEmpty() && StringUtils.isNotBlank(user)) {
            log.trace("-- no active session, set some userVersion");
            userRegionVersions = this.getRegionVersionsForUser(profile2, user, configuration);
            log.trace("creating cacheKey for userRegionVersions: {}", (Object)userRegionVersions);
            TreeDomain tree = this.createTreeFor(profile2, -1, userRegionVersions);
            CacheKey cacheKey = this.createCacheKeyByVersions(user, profile2, userRegionVersions);
            log.trace("no active session. Created cacheKey: {}", (Object)cacheKey);
            result.put(cacheKey, tree);
        }
        log.trace("finishing createTrees(profile={},user={}, configuration={})", profile2, user, configuration);
        return result;
    }

    public CacheKey createCacheKeyByVersions(String userName, String profile2, Set<Integer> userRegionVersions) {
        return new CacheKey(SessionIdBuilder.getId(userName, profile2), userRegionVersions);
    }

    public CacheKey createCacheKeyByConfiguration(String userName, String profileCode, EffectiveVersionConfiguration configuration) {
        if (configuration != null && configuration.isSnapshotExportConfiguration()) {
            return this.createCacheKeyWithAllProfileRegionVersions(userName, profileCode, configuration);
        }
        Set<Integer> regionVersionsForUser = this.getRegionVersionsForUser(profileCode, userName, configuration);
        return this.createCacheKeyByVersions(userName, profileCode, regionVersionsForUser);
    }

    private CacheKey createCacheKeyWithAllProfileRegionVersions(String userName, String profileCode, EffectiveVersionConfiguration configuration) {
        Set<Integer> allProfileRegionVersionIds = configuration.getAllRegionVersionsOnlyForSnapshotExport().stream().map(RegionVersion::getId).collect(Collectors.toSet());
        return this.createCacheKeyByVersions(userName, profileCode, allProfileRegionVersionIds);
    }

    public HyperonDomainObject reloadElement(String childPath, int childElementId, HyperonDomainObjectType type, TreeDomain tree, String profile2, String user) {
        Set<Integer> regionIds = this.getRegionVersionsForUser(profile2, user);
        HyperonDomainObjectImpl element = this.dao.getObjectById(childElementId, childPath, (HyperonDomainObjectTypeImpl)type, this.valueProvider, regionIds);
        if (element == null) {
            return null;
        }
        List<ReferenceDto> references = this.dao.getReferences(childElementId);
        for (ReferenceDto path : references) {
            HyperonDomainObject referenced = tree.getObjectsByPath(path.getPath().substring(0, path.getPath().length() - 1));
            if (referenced == null) {
                HyperonDomainObjectTypeImpl collection = new HyperonDomainObjectTypeImpl(path.getCollectionId(), path.getParentCollectionCode(), "");
                referenced = new HyperonDomainObjectImpl(HyperonDomainObjectImpl.getTmpId(), "!!", path.getPath(), "", collection, element.getId(), true);
                ((HyperonDomainObjectImpl)referenced).setRegion(new RegionCached());
            }
            element.addReference((HyperonDomainObjectImpl)referenced, path.getParentCollectionCode());
        }
        return element;
    }

    public HyperonDomainObjectType getTypeForElement(String profileCode, int childElementId) {
        Map<String, HyperonDomainObjectTypeImpl> types = this.dao.getTypesByCode(profileCode);
        Integer typeId = this.dao.getCollectionId(childElementId);
        return types.get(Integer.toString(typeId));
    }

    private Set<Integer> getRegionVersionsForUser(String profile2, String user) {
        return this.getRegionVersionsForUser(profile2, user, null);
    }

    public Set<Integer> getRegionVersionsForUser(String profileCode, String user, EffectiveVersionConfiguration configuration) {
        Set<RegionVersion> userVersions = this.userRegionVersionProvider.get(profileCode, user);
        return this.effectiveVersionResolver.getEffectiveVersionIds(profileCode, configuration, userVersions);
    }

    private List<OpenSession> getOpenSessionsForUser(String profile2, String user) {
        return this.dao.getOpenSessions(profile2, user);
    }

    private TreeDomain createTreeFor(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        log.trace("entering createTreeFor(profile={},sessionId={}, userRegions={})", profileCode, sessionId, userRegionVersions);
        long start = System.currentTimeMillis();
        Map<String, HyperonDomainObjectTypeImpl> typesByCodes = this.dao.getTypesByCode(profileCode);
        Map<String, HyperonDomainObjectImpl> objectsByIds = this.dao.getObjectsById(profileCode, sessionId, typesByCodes, userRegionVersions);
        Map<String, List<ReferenceDto>> parentReference = this.dao.getReferences(profileCode, sessionId, userRegionVersions);
        Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> dynamicAttributesByObjectIds = this.dao.getObjectsDynamicAttributesByObjectId(profileCode, sessionId, userRegionVersions);
        Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> attributesByObjectIds = this.dao.getObjectsAttributesByObjectId(profileCode, sessionId, userRegionVersions);
        TreeDomain treeDomain = new TreeDomain(profileCode);
        if (sessionId > -1) {
            treeDomain.addNewParents(this.dao.getNewParents(profileCode, userRegionVersions));
            this.findInconsistency(objectsByIds, treeDomain);
        }
        List<HyperonDomainObjectImpl> roots = this.getRootsAndInitOthers(objectsByIds, dynamicAttributesByObjectIds, attributesByObjectIds, treeDomain);
        this.processChildren(roots, objectsByIds, dynamicAttributesByObjectIds, attributesByObjectIds, treeDomain);
        treeDomain.setRoots(roots, typesByCodes, parentReference, this.concatAttributes(dynamicAttributesByObjectIds, attributesByObjectIds));
        long time = System.currentTimeMillis() - start;
        log.trace("finishing createTreeFor(profile={},sessionId={}) in time {}", profileCode, sessionId, time);
        return treeDomain;
    }

    private Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> concatAttributes(Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> dynamicAttributesByObjectIds, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> attributesByObjectIds) {
        return Stream.concat(dynamicAttributesByObjectIds.entrySet().stream(), attributesByObjectIds.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (attrs1, attrs2) -> {
            ArrayList concatList = new ArrayList(attrs1.size() + attrs2.size());
            concatList.addAll(attrs1);
            concatList.addAll(attrs2);
            return concatList;
        }));
    }

    private void findInconsistency(Map<String, HyperonDomainObjectImpl> objectsByIds, TreeDomain treeDomain) {
        HashMap<Integer, List<Integer>> parentAndChildren = new HashMap<Integer, List<Integer>>();
        HashSet<Integer> baseElementOpenIsSession = new HashSet<Integer>();
        for (Map.Entry<String, HyperonDomainObjectImpl> entry : objectsByIds.entrySet()) {
            if (entry.getValue().getParentId() == null) {
                this.getChildren(parentAndChildren, -1).add(entry.getValue().getId());
            } else {
                this.getChildren(parentAndChildren, entry.getValue().getParentId()).add(entry.getValue().getId());
            }
            if (entry.getValue().isHead() || entry.getValue().getId().equals(entry.getValue().getIdToSelectChildren())) continue;
            baseElementOpenIsSession.add(entry.getValue().getIdToSelectChildren());
        }
        HashMap<String, Integer> duplicateTmpId = new HashMap<String, Integer>();
        for (Map.Entry parent : parentAndChildren.entrySet()) {
            if ((Integer)parent.getKey() != -1 && !baseElementOpenIsSession.contains(parent.getKey()) && !objectsByIds.containsKey(Integer.toString((Integer)parent.getKey()))) {
                for (Integer child : (List)parent.getValue()) {
                    HyperonDomainObjectImpl hyperonDomainObjectImpl = objectsByIds.get(Integer.toString(child));
                    treeDomain.addInconsistency(DomainTokenResolver.resolveFullToken(this.getTypeCollectionCode(hyperonDomainObjectImpl), hyperonDomainObjectImpl.getCode()));
                }
            }
            duplicateTmpId.clear();
            for (Integer child : (List)parent.getValue()) {
                HyperonDomainObjectImpl hyperonDomainObjectImpl = objectsByIds.get(Integer.toString(child));
                StringBuilder tmpId = new StringBuilder(DomainTokenResolver.resolveFullToken(this.getTypeCollectionCode(hyperonDomainObjectImpl), hyperonDomainObjectImpl.getCode()));
                Integer previous = (Integer)duplicateTmpId.get(tmpId.toString());
                if (previous != null) {
                    HyperonDomainObjectImpl elementPrevious = objectsByIds.get(Integer.toString(previous));
                    treeDomain.addDuplicated(tmpId.toString());
                    if (hyperonDomainObjectImpl.isHead()) {
                        objectsByIds.remove(Integer.toString(hyperonDomainObjectImpl.getId()));
                    } else if (elementPrevious.isHead()) {
                        objectsByIds.remove(Integer.toString(elementPrevious.getId()));
                    }
                }
                duplicateTmpId.put(tmpId.toString(), hyperonDomainObjectImpl.getId());
            }
        }
    }

    private String getTypeCollectionCode(HyperonDomainObjectImpl element) {
        return element.getTypeCollection().getCode();
    }

    private List<Integer> getChildren(Map<Integer, List<Integer>> parentAndChildren, Integer parentId) {
        return parentAndChildren.computeIfAbsent(parentId, k -> new ArrayList());
    }

    private void processChildren(List<HyperonDomainObjectImpl> parents, Map<String, HyperonDomainObjectImpl> objectsByIds, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> dynamicAttributesByObjectIds, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> attributesByObjectIds, TreeDomain treeDomain) {
        for (HyperonDomainObjectImpl object : parents) {
            String id = Integer.toString(object.getIdToSelectChildren());
            if (this.wasChangedByOtherSession(treeDomain, object)) {
                log.warn("change from: {} to {}", (Object)id, (Object)treeDomain.getNewParentId(object.getCopyFrom()));
                id = treeDomain.getNewParentId(object.getCopyFrom());
                object.setIdToSelectChildren(Integer.valueOf(id));
            }
            ArrayList<HyperonDomainObjectImpl> children = new ArrayList<HyperonDomainObjectImpl>();
            for (String childId : treeDomain.getChildrenIds(id)) {
                children.add(this.getObjectWithAllAttributes(dynamicAttributesByObjectIds, attributesByObjectIds, objectsByIds.get(childId)));
            }
            if (!Integer.toString(object.getId()).equals(id)) {
                id = Integer.toString(object.getId());
                for (String childId : treeDomain.getChildrenIds(id)) {
                    HyperonDomainObjectImpl child = this.getObjectWithAllAttributes(dynamicAttributesByObjectIds, attributesByObjectIds, objectsByIds.get(childId));
                    children.add(child);
                }
            }
            this.processChildren(children, objectsByIds, dynamicAttributesByObjectIds, attributesByObjectIds, treeDomain);
            object.setChildren(children);
        }
    }

    private boolean wasChangedByOtherSession(TreeDomain treeDomain, HyperonDomainObjectImpl object) {
        return !object.isHead() && treeDomain.isChangeCopyFrom(object.getCopyFrom());
    }

    private List<HyperonDomainObjectImpl> getRootsAndInitOthers(Map<String, HyperonDomainObjectImpl> objectsByIds, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> dynamicAttributesByObjectIds, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> attributesByObjectIds, TreeDomain treeDomain) {
        ArrayList<HyperonDomainObjectImpl> roots = new ArrayList<HyperonDomainObjectImpl>();
        Iterator<Map.Entry<String, HyperonDomainObjectImpl>> objectIterator = objectsByIds.entrySet().iterator();
        while (objectIterator.hasNext()) {
            Map.Entry<String, HyperonDomainObjectImpl> object = objectIterator.next();
            treeDomain.initObjectIdsAndPath(object.getValue());
            if (!this.isRoot(object.getValue())) continue;
            HyperonDomainObjectImpl root = this.getObjectWithAllAttributes(dynamicAttributesByObjectIds, attributesByObjectIds, object.getValue());
            roots.add(root);
            objectIterator.remove();
        }
        return roots;
    }

    private HyperonDomainObjectImpl getObjectWithAllAttributes(Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> dynamicAttributesByObjectIds, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> attributesByObjectIds, HyperonDomainObjectImpl object) {
        String id = Integer.toString(object.getId());
        ArrayList<HyperonDomainAttribute> objectAttributes = new ArrayList<HyperonDomainAttribute>();
        if (dynamicAttributesByObjectIds.get(id) != null) {
            for (DomainCacheJdbcDao.DomainAttributeLoadWrapper attribute : dynamicAttributesByObjectIds.get(id)) {
                objectAttributes.add(new HyperonDomainAttribute(attribute.getDto(), object, this.valueProvider));
            }
            object.setDynamicAttributes(objectAttributes);
        }
        objectAttributes = new ArrayList();
        if (attributesByObjectIds.get(id) != null) {
            for (DomainCacheJdbcDao.DomainAttributeLoadWrapper attribute : attributesByObjectIds.get(id)) {
                DomainAttributeDto attributeDto = attribute.getDto();
                attributeDto.setDomainType(object.getCollection());
                objectAttributes.add(new HyperonDomainAttribute(attributeDto, object, this.valueProvider));
            }
            object.setAttributes(objectAttributes);
        }
        return object;
    }

    private boolean isRoot(HyperonDomainObjectImpl object) {
        return object.getParentId() == null;
    }
}

