/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.versioninterceptor;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pl.decerto.hyperon.runtime.cache.ProfileProvider;
import pl.decerto.hyperon.runtime.core.versioninterceptor.VersionInterceptor;
import pl.decerto.hyperon.runtime.model.ElementType;
import pl.decerto.hyperon.runtime.model.Schedule;
import pl.decerto.hyperon.runtime.model.ScheduleEntry;
import pl.decerto.hyperon.runtime.model.region.RegionVersionIdentifier;
import pl.decerto.hyperon.runtime.provider.MpScheduleProvider;
import pl.decerto.hyperon.runtime.sync.ScheduleCache;

public class RuntimeVersionInterceptor
implements VersionInterceptor {
    private static final String UID_FORMAT = "%s@%s";
    private final ThreadLocal<Map<String, RegionVersionContainer>> versionToUse = new ThreadLocal();
    private final ThreadLocal<Date> dateToUse = new ThreadLocal();
    private final MpScheduleProvider provider;
    private final ProfileProvider profileProvider;

    public RuntimeVersionInterceptor(MpScheduleProvider provider, ProfileProvider profileProvider) {
        this.provider = provider;
        this.profileProvider = profileProvider;
    }

    @Override
    public String decorateParameterUid(String parameterName) {
        Schedule schedule;
        Schedule schedule2;
        if (parameterName.contains(":") || parameterName.contains("@")) {
            return parameterName;
        }
        Map<String, RegionVersionContainer> map = this.versionToUse.get();
        if (map != null && !map.isEmpty() && (schedule2 = this.cache().getParameterSchedule(parameterName)) != null) {
            return this.uid(parameterName, schedule2, map);
        }
        Date date = this.dateToUse.get();
        if (date != null && (schedule = this.cache().getParameterSchedule(parameterName)) != null) {
            return this.uid(parameterName, schedule, date);
        }
        return parameterName;
    }

    @Override
    public String decorateFunctionUid(String functionName) {
        Schedule schedule;
        Schedule schedule2;
        if (functionName.contains(":") || functionName.contains("@")) {
            return functionName;
        }
        Map<String, RegionVersionContainer> map = this.versionToUse.get();
        if (map != null && !map.isEmpty() && (schedule2 = this.cache().getFunctionSchedule(functionName)) != null) {
            return this.uid(functionName, schedule2, map);
        }
        Date date = this.dateToUse.get();
        if (date != null && (schedule = this.cache().getFunctionSchedule(functionName)) != null) {
            return this.uid(functionName, schedule, date);
        }
        return functionName;
    }

    @Override
    public void setEffectiveVersion(String regionCode, String version) {
        this.profileProvider.get(regionCode, version).ifPresent(profile2 -> {
            Map<String, RegionVersionContainer> profileToVersionContainer = this.versionToUse();
            RegionVersionContainer regionVersionContainer = profileToVersionContainer.computeIfAbsent((String)profile2, code -> new RegionVersionContainer());
            regionVersionContainer.put(regionCode, version);
        });
    }

    @Override
    public void setEffectiveVersion(String profileCode, String regionCode, String version) {
        RegionVersionContainer container = this.versionToUse().get(profileCode);
        if (Objects.isNull(container)) {
            container = new RegionVersionContainer();
            this.versionToUse().put(profileCode, container);
        }
        container.put(regionCode, version);
    }

    @Override
    public void setEffectiveDate(Date effDate) {
        if (effDate == null) {
            this.dateToUse.remove();
        } else {
            this.dateToUse.set(new Date(effDate.getTime()));
        }
    }

    @Override
    public void clearEffectiveVersion(String regionCode) {
        this.profileProvider.get(regionCode, null).ifPresent(profileCode -> this.clearEffectiveVersion((String)profileCode, regionCode));
    }

    @Override
    public void clearEffectiveVersion(String profileCode, String regionCode) {
        Map<String, RegionVersionContainer> mapping = this.versionToUse();
        RegionVersionContainer rvc = mapping.get(profileCode);
        if (Objects.nonNull(rvc)) {
            rvc.remove(regionCode);
            if (rvc.isEmpty()) {
                mapping.remove(profileCode);
            }
        }
    }

    @Override
    public void clearEffectiveVersions() {
        this.versionToUse().clear();
    }

    @Override
    public void clearEffectiveDate() {
        this.dateToUse.remove();
    }

    @Override
    public void clearEffectiveSetup() {
        this.clearEffectiveVersions();
        this.clearEffectiveDate();
    }

    @Override
    public Optional<Date> getEffectiveDate() {
        return Optional.ofNullable(this.dateToUse.get());
    }

    @Override
    public Set<RegionVersionIdentifier> getEffectiveVersions(String profileCode) {
        Set entries = Optional.ofNullable(this.versionToUse().get(profileCode)).map(container -> container.regionToVersionMapping.entrySet()).orElse(Collections.emptySet());
        return entries.stream().map(entry -> new RegionVersionIdentifier(profileCode, (String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toSet());
    }

    public Set<RegionVersionIdentifier> getEffectiveVersions() {
        HashSet<RegionVersionIdentifier> versions = new HashSet<RegionVersionIdentifier>();
        this.versionToUse().forEach((profileCode, container) -> container.regionToVersionMapping.forEach((region, version) -> versions.add(new RegionVersionIdentifier((String)profileCode, (String)region, (String)version))));
        return versions;
    }

    public Optional<String> getEffectiveVersion(String code, String profileCode, String regionCode, ElementType elementType) {
        Optional<String> effectiveVersion;
        Map<String, RegionVersionContainer> map = this.versionToUse.get();
        if (map != null && !map.isEmpty() && map.containsKey(profileCode) && (effectiveVersion = map.get(profileCode).get(regionCode)).isPresent()) {
            return effectiveVersion;
        }
        return this.getVersionByEffectiveDate(code, elementType);
    }

    private Optional<String> getVersionByEffectiveDate(String code, ElementType elementType) {
        Date date = this.dateToUse.get();
        if (Objects.nonNull(date)) {
            return this.getSchedule(code, elementType).flatMap(schedule -> schedule.find(date)).map(ScheduleEntry::getVersion);
        }
        return Optional.empty();
    }

    private Optional<Schedule> getSchedule(String code, ElementType elementType) {
        return Optional.ofNullable(this.cache().getSchedule(code, elementType));
    }

    private ScheduleCache cache() {
        return this.provider.cache();
    }

    private String uid(String code, String ver) {
        return ver != null ? String.format(UID_FORMAT, code, ver) : code;
    }

    private String uid(String code, Schedule schedule, Map<String, RegionVersionContainer> map) {
        String regionCode = schedule.getRegion();
        String profileCode = schedule.getProfileCode();
        String version = Optional.ofNullable(map.get(profileCode)).flatMap(container -> container.get(regionCode)).orElse(null);
        return this.uid(code, version);
    }

    private String uid(String code, Schedule schedule, Date date) {
        String version = schedule.find(date).map(ScheduleEntry::getVersion).orElse(null);
        return this.uid(code, version);
    }

    private Map<String, RegionVersionContainer> versionToUse() {
        Map<String, RegionVersionContainer> map = this.versionToUse.get();
        if (map == null) {
            map = new HashMap<String, RegionVersionContainer>();
            this.versionToUse.set(map);
        }
        return map;
    }

    private class RegionVersionContainer {
        private Map<String, String> regionToVersionMapping = new HashMap<String, String>();

        private RegionVersionContainer() {
        }

        void put(String regionCode, String version) {
            this.regionToVersionMapping.put(regionCode, version);
        }

        Optional<String> get(String regionCode) {
            return Optional.ofNullable(this.regionToVersionMapping.get(regionCode));
        }

        void remove(String regionCode) {
            this.regionToVersionMapping.remove(regionCode);
        }

        boolean isEmpty() {
            return this.regionToVersionMapping.isEmpty();
        }
    }
}

