/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.profiler;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.smartparam.engine.util.Separator;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.profiler.AbstractProfilerStat;

public abstract class ProfilerHelper {
    private static final int SUMMARY_INIT_SIZE = 2000;
    private static final int COL_SIZE = 8;
    private static final int MIN_KEY_LENGTH = 4;
    private static final String NL = Separator.DEFAULT.getValue();
    private static final String COLUMN_SEPARATOR = " | ";

    private ProfilerHelper() {
    }

    public static <S extends AbstractProfilerStat<?>> String printSummaryAsHtml(List<S> stats, String title) {
        StringWriter writer = new StringWriter(2000);
        ProfilerHelper.writeSummaryAsHtml(writer, stats, title);
        return writer.toString();
    }

    public static <S extends AbstractProfilerStat<?>> String printSummaryAsText(List<S> stats, String title) {
        StringWriter writer = new StringWriter(2000);
        ProfilerHelper.writeSummary(writer, stats, title);
        return writer.toString();
    }

    public static <S extends AbstractProfilerStat<?>> void writeSummaryAsHtml(Writer w, List<S> stats, String title) {
        ProfilerHelper.write(w, "<html>");
        ProfilerHelper.write(w, "<pre>");
        ProfilerHelper.writeSummary(w, stats, title);
        ProfilerHelper.write(w, "</pre>");
        ProfilerHelper.write(w, "</html>");
    }

    public static <S extends AbstractProfilerStat<?>> void writeSummary(Writer w, List<S> stats, String title) {
        int maxKeyLen = ProfilerHelper.getMaxKeyLength(stats);
        ProfilerHelper.write(w, NL + title + NL);
        ProfilerHelper.writeHeader(w, maxKeyLen);
        for (AbstractProfilerStat stat : stats) {
            ProfilerHelper.writeLine(w, maxKeyLen, stat);
        }
    }

    public static void writeln(Writer w, String str) {
        ProfilerHelper.write(w, str + NL);
    }

    private static void write(Writer writer, String str) {
        try {
            writer.write(str);
        }
        catch (IOException e) {
            throw new HyperonRuntimeException("writing to stream failed", e);
        }
    }

    public static <S extends AbstractProfilerStat<?>> String printSummary(List<S> statistics, String title) {
        return ProfilerHelper.printSummaryAsHtml(statistics, title);
    }

    private static <S extends AbstractProfilerStat<?>> int getMaxKeyLength(List<S> stats) {
        int maxKeyLen = 4;
        for (AbstractProfilerStat stat : stats) {
            maxKeyLen = Math.max(stat.getKey().toString().length(), maxKeyLen);
        }
        return maxKeyLen;
    }

    private static void writeHeader(Writer w, int len) {
        ProfilerHelper.writeLine(w, new Header(len, "key", "count", "total", "avg").withMin("min").withMax("max"));
    }

    private static <S extends AbstractProfilerStat<?>> void writeLine(Writer w, int len, S stat) {
        ProfilerHelper.writeLine(w, new Header(len, stat.getKey().toString(), stat.getCount(), stat.getTotalTime(), stat.getAvgTime()).withMin("" + stat.getMinTime()).withMax("" + stat.getMaxTime()));
    }

    private static void writeLine(Writer w, Header header) {
        ProfilerHelper.write(w, StringUtils.rightPad(header.key, header.len) + COLUMN_SEPARATOR);
        ProfilerHelper.write(w, StringUtils.leftPad(header.count, 8) + COLUMN_SEPARATOR);
        ProfilerHelper.write(w, StringUtils.leftPad(header.total, 8) + COLUMN_SEPARATOR);
        ProfilerHelper.write(w, StringUtils.leftPad(header.avg, 8) + COLUMN_SEPARATOR);
        ProfilerHelper.write(w, StringUtils.leftPad(header.min, 8) + COLUMN_SEPARATOR);
        ProfilerHelper.write(w, StringUtils.leftPad(header.max, 8) + COLUMN_SEPARATOR);
        ProfilerHelper.write(w, NL);
    }

    private static final class Header {
        private int len;
        private String key;
        private String count;
        private String total;
        private String avg;
        private String min;
        private String max;

        private Header(int len, String key, String count, String total, String avg) {
            this.len = len;
            this.key = key;
            this.count = count;
            this.total = total;
            this.avg = avg;
        }

        private Header(int len, String key, long count, long total, double avg) {
            this.len = len;
            this.key = key;
            this.count = "" + count;
            this.total = "" + total;
            this.avg = String.format("%.2f", avg);
        }

        private Header withMin(String min) {
            this.min = min;
            return this;
        }

        private Header withMax(String max) {
            this.max = max;
            return this;
        }
    }
}

