CREATE TABLE IF NOT EXISTS  category
(
    id            int          not null
        primary key,
    accesscontrol bit          not null,
    active        bit          not null,
    description   varchar(255) null,
    name          varchar(200) not null,
    constraint uk_category_name
        unique (name)
);

CREATE TABLE IF NOT EXISTS configparams
(
    id           int          not null
        primary key,
    area         varchar(20)  not null,
    createddate  timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    modifiedby   varchar(512) not null,
    modifieddate timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    paramcode    varchar(100) not null,
    paramvalue   varchar(150) not null,
    constraint uk_configparam_area_code
        unique (area, paramcode)
);

CREATE TABLE IF NOT EXISTS domain_profile
(
    code        varchar(255) not null
        primary key,
    description varchar(255) null
);

CREATE TABLE IF NOT EXISTS domaintype
(
    id           int          not null
        primary key,
    createdby    varchar(255) null,
    createddate  timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    modifiedby   varchar(512) null,
    modifieddate timestamp(3) null,
    archive      bit          not null,
    code         varchar(200) null,
    name         varchar(255) null,
    roottype     bit          not null,
    typenature   varchar(255) null,
    profile_code varchar(255) null,
    description  varchar(512) null,
    constraint uk_domaintype_profile_code
        unique (profile_code, code),
    constraint fk_type_profile
        foreign key (profile_code) references domain_profile (code)
);

create index ix_dt_prof_id
    on domaintype (profile_code, id);

CREATE TABLE IF NOT EXISTS domaintypeattribute
(
    id             int          not null
        primary key,
    createdby      varchar(255) null,
    createddate    timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    modifiedby     varchar(512) null,
    modifieddate   timestamp(3) null,
    archive        bit          not null,
    attrorder      int          not null,
    attrtype       varchar(255) not null,
    code           varchar(200) null,
    defaultrefname varchar(255) null,
    defaultreftype varchar(255) null,
    groupname      varchar(100) null,
    name           varchar(255) null,
    type_id        int          not null,
    grouporder     int          not null,
    description    varchar(512) null,
    constraint uk_dtattribute_type_code
        unique (type_id, code),
    constraint fk_dta_type
        foreign key (type_id) references domaintype (id)
);

CREATE TABLE IF NOT EXISTS domaintypecollection
(
    id                int          not null
        primary key,
    createdby         varchar(255) null,
    createddate       timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    modifiedby        varchar(512) null,
    modifieddate      timestamp(3) null,
    archive           bit          not null,
    code              varchar(200) null,
    collorder         int          not null,
    multiple          bit          not null,
    name              varchar(255) null,
    visible           bit          not null,
    collectiontype_id int          not null,
    type_id           int          not null,
    constraint uk_dtcollection_type_code
        unique (type_id, code),
    constraint fk_coll_collection_type
        foreign key (collectiontype_id) references domaintype (id),
    constraint fk_collection_type
        foreign key (type_id) references domaintype (id)
);

CREATE TABLE IF NOT EXISTS externalstorage
(
    id    int      not null
        primary key,
    value longtext null
);

CREATE TABLE IF NOT EXISTS functionimpl
(
    type       varchar(31)   not null,
    id         int           not null
        primary key,
    body       longtext      null,
    args       varchar(1000) null,
    beanname   varchar(255)  null,
    methodname varchar(255)  null,
    classname  varchar(255)  null
);

CREATE TABLE IF NOT EXISTS functionformalargument
(
    id          int          not null
        primary key,
    datatype    varchar(20)  not null,
    name        varchar(40)  null,
    class       varchar(200) null,
    function_id int          not null,
    ordercolumn int          null,
    constraint uk_funformalarg_name_id
        unique (name, function_id),
    constraint fk_ffarg_funimpl
        foreign key (function_id) references functionimpl (id)
);

CREATE TABLE IF NOT EXISTS import_history
(
    id          int          not null
        primary key,
    file_name   varchar(255) not null,
    auto_commit bit          not null,
    import_date timestamp(3)  DEFAULT CURRENT_TIMESTAMP(3)  not null ,
    username    varchar(255) not null,
    status      varchar(50)  not null
);

CREATE TABLE IF NOT EXISTS import_history_element
(
    id                int          not null
        primary key,
    json              longtext     null,
    type              varchar(255) null,
    import_history_id int          not null,
    constraint import_history_element_fk
        foreign key (import_history_id) references import_history (id)
);

CREATE TABLE IF NOT EXISTS jwttoken
(
    id              int          not null
        primary key,
    user_id         int          not null,
    token           varchar(512) not null,
    expiration_date timestamp(3)  DEFAULT CURRENT_TIMESTAMP(3)  not null ,
    create_date     timestamp(3)  DEFAULT CURRENT_TIMESTAMP(3)  not null 
);

CREATE TABLE IF NOT EXISTS license
(
    id                int          not null
        primary key,
    signature         varchar(172) not null,
    validFrom         timestamp(3)  DEFAULT CURRENT_TIMESTAMP(3)  not null ,
    validTo           timestamp(3) null,
    licenseNumber     varchar(8)   not null,
    licensee          varchar(255) not null,
    permittedCpuCores int          null,
    specialConditions longtext     null
);

CREATE TABLE IF NOT EXISTS lifesimulationparameters
(
    id           int          not null
        primary key,
    content      longtext     null,
    createddate  timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    modifiedby   varchar(512) not null,
    modifieddate timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    name         varchar(512) not null
);

CREATE TABLE IF NOT EXISTS profile_configuration
(
    profile_code              varchar(255) null,
    default_tag               varchar(255) null,
    add_tag_to_new_parameters bit          null,
    add_tag_to_new_functions  bit          null,
    filter_parameters         bit          null,
    filter_functions          bit          null,
    constraint fk_domain_profile_code
        foreign key (profile_code) references domain_profile (code)
);

CREATE TABLE IF NOT EXISTS region
(
    id           int              not null
        primary key,
    archive      bit default b'0' not null,
    code         varchar(30)      not null,
    createdby    varchar(255)     null,
    createddate  timestamp        not null,
    description  varchar(512)     null,
    profile_code varchar(255)     null,
    constraint fk_region_profile
        foreign key (profile_code) references domain_profile (code)
);

CREATE TABLE IF NOT EXISTS regionversion
(
    id             int              not null
        primary key,
    active         bit              null,
    archive        bit default b'0' not null,
    createdby      varchar(255)     null,
    createddate    timestamp        not null,
    description    varchar(512)     null,
    editiondisable bit default b'0' not null,
    lastupdate     timestamp(3)     null,
    versionnumber  varchar(50)      null,
    region_id      int              not null,
    constraint fk_version_region
        foreign key (region_id) references region (id)
);

CREATE TABLE IF NOT EXISTS domainelement
(
    id               int          not null
        primary key,
    archive          bit          not null,
    code             varchar(200) null,
    copyfromid       int          null,
    head             bit          not null,
    lastupdate       timestamp(3) null,
    name             varchar(255) null,
    worksessionid    int          not null,
    collection_id    int          not null,
    parent_id        int          null,
    profile_code     varchar(255) null,
    regionversion_id int          null,
    description      varchar(512) null,
    constraint uk_domainelement_code
        unique (parent_id, code, collection_id, regionversion_id, worksessionid),
    constraint fk_delement_profile
        foreign key (profile_code) references domain_profile (code),
    constraint fk_delement_region
        foreign key (regionversion_id) references regionversion (id),
    constraint fk_element_coll
        foreign key (collection_id) references domaintypecollection (id),
    constraint fk_element_parent
        foreign key (parent_id) references domainelement (id)
);

create index ix_de_prof_head
    on domainelement (profile_code, head);

create index ix_de_prof_sid
    on domainelement (profile_code, worksessionid);

CREATE TABLE IF NOT EXISTS domainelement_category
(
    domainelements_id int not null,
    categories_id     int not null,
    primary key (domainelements_id, categories_id),
    constraint fk_category_delement
        foreign key (categories_id) references category (id),
    constraint fk_domain_delement
        foreign key (domainelements_id) references domainelement (id)
);

CREATE TABLE IF NOT EXISTS domainelementattribute
(
    id               int          not null
        primary key,
    refname          varchar(255) null,
    reftype          varchar(255) null,
    domainelement_id int          not null,
    typeattribute_id int          not null,
    constraint uk_domainelement_typeattr
        unique (domainelement_id, typeattribute_id),
    constraint fk_deattr_delement
        foreign key (domainelement_id) references domainelement (id),
    constraint fk_eattr_tattr
        foreign key (typeattribute_id) references domaintypeattribute (id)
);

CREATE TABLE IF NOT EXISTS domainelementextraattr
(
    id               int                            not null
        primary key,
    attrtype         varchar(255)                   null,
    attrvalue        varchar(128)                   null,
    code             varchar(200)                   null,
    name             varchar(255)                   null,
    domainelement_id int                            not null,
    reftype          varchar(255) default 'LITERAL' null,
    description      varchar(512)                   null,
    constraint uk_domainelement_attrcode
        unique (domainelement_id, code),
    constraint fk_deea_delement
        foreign key (domainelement_id) references domainelement (id)
);

CREATE TABLE IF NOT EXISTS domainreference
(
    id            int          not null
        primary key,
    elementpath   varchar(255) not null,
    collection_id int          not null,
    parent_id     int          null,
    constraint uk_domainreference
        unique (parent_id, collection_id, elementpath),
    constraint fk_ref_coll
        foreign key (collection_id) references domaintypecollection (id),
    constraint fk_ref_parent
        foreign key (parent_id) references domainelement (id)
);

CREATE TABLE IF NOT EXISTS hyp_function
(
    id                int                        not null
        primary key,
    archive           bit                        null,
    head              bit                        null,
    lastupdate        timestamp(3)               null,
    name              varchar(255)               null,
    type              varchar(30)                null,
    worksessionid     int                        null,
    implementation_id int                        not null,
    regionversion_id  int                        null,
    log_level         varchar(16) default 'INFO' not null,
    description       varchar(4000)              null,
    constraint u_fun_codeversid
        unique (name, regionversion_id, worksessionid),
    constraint fk_fun_impl
        foreign key (implementation_id) references functionimpl (id),
    constraint fk_fun_region
        foreign key (regionversion_id) references regionversion (id)
);

create index ix_f_lastupdate
    on hyp_function (lastupdate);

CREATE TABLE IF NOT EXISTS hyp_function_category
(
    functions_id  int not null,
    categories_id int not null,
    primary key (functions_id, categories_id),
    constraint fk_category_fun
        foreign key (functions_id) references hyp_function (id),
    constraint fk_fun_category
        foreign key (categories_id) references category (id)
);

CREATE TABLE IF NOT EXISTS parameter
(
    id                    int              not null
        primary key,
    archive               bit              not null,
    arrayseparator        char             not null,
    cacheable             bit              not null,
    description           varchar(4000)    null,
    digest                varchar(40)      null,
    head                  bit              not null,
    label                 varchar(255)     not null,
    lastupdate            timestamp(3)     null,
    name                  varchar(255)     not null,
    nullable              bit              not null,
    sort                  varchar(100)     null,
    worksessionid         int              not null,
    regionversion_id      int              null,
    mastername            varchar(255)     null,
    slave                 bit default b'0' not null,
    distinct_flag         bit default b'0' not null,
    external_source       bit default b'0' not null,
    external_datasource   varchar(100)     null,
    external_inmem_query  longtext         null,
    external_nonmem_query longtext         null,
    auto_refresh          bit default b'0' not null,
    auto_refresh_period   varchar(255)     null,
    dictionary            bit default b'0' not null,
    constraint u_par_codeversid
        unique (name, regionversion_id, worksessionid),
    constraint fk_param_region
        foreign key (regionversion_id) references regionversion (id)
);

create index ix_p_lastupdate
    on parameter (lastupdate);

CREATE TABLE IF NOT EXISTS parameter_category
(
    parameters_id int not null,
    categories_id int not null,
    primary key (parameters_id, categories_id),
    constraint fk_param_category
        foreign key (categories_id) references category (id),
    constraint fk_param_param
        foreign key (parameters_id) references parameter (id)
);

CREATE TABLE IF NOT EXISTS parameterentry
(
    id           int           not null
        primary key,
    level1       varchar(500)  null,
    level2       varchar(500)  null,
    level3       varchar(500)  null,
    level4       varchar(500)  null,
    level5       varchar(2000) null,
    level6       varchar(2000) null,
    level7       varchar(2000) null,
    level8       varchar(2000) null,
    sha1code     varchar(64)   not null,
    parameter_id int           not null,
    constraint fk_entry_parameter
        foreign key (parameter_id) references parameter (id)
);

create index ix_pe_pid
    on parameterentry (parameter_id);

create index ix_pe_pidlevel1
    on parameterentry (parameter_id, level1);

CREATE TABLE IF NOT EXISTS parameterlevel
(
    leveltype        varchar(31)      not null,
    id               int              not null
        primary key,
    code             varchar(255)     not null,
    label            varchar(255)     not null,
    orderno          int              not null,
    type             varchar(30)      not null,
    levelcreator     varchar(100)     null,
    matcher          varchar(30)      null,
    property         varchar(255)     null,
    union_flag       bit              null,
    array_flag       bit              null,
    external_flag    bit              null,
    parameter_id_in  int              null,
    parameter_id_out int              null,
    foreignkey       varchar(550)     null,
    reverse_matcher  bit default b'0' not null,
    constraint fk_level_in_parameter
        foreign key (parameter_id_in) references parameter (id),
    constraint fk_level_parameter
        foreign key (parameter_id_out) references parameter (id)
);

create index ix_paramlevel_pid_in
    on parameterlevel (parameter_id_in);

create index ix_paramlevel_pid_out
    on parameterlevel (parameter_id_out);

CREATE TABLE IF NOT EXISTS regionversionschedule
(
    id               int       not null
        primary key,
    createddate      timestamp null,
    editableto       timestamp  DEFAULT CURRENT_TIMESTAMP  not null ,
    validfrom        timestamp  DEFAULT CURRENT_TIMESTAMP  not null ,
    regionversion_id int       not null,
    constraint fk_schedule_region
        foreign key (regionversion_id) references regionversion (id)
);

CREATE TABLE IF NOT EXISTS resetpasswordtoken
(
    id     int          not null
        primary key,
    email  varchar(255) not null,
    status varchar(255) null,
    token  varchar(255) not null,
    constraint uk_resetpasswordtoken_email
        unique (email)
);

CREATE TABLE IF NOT EXISTS sandboxtypesdefinition
(
    id           int           not null
        primary key,
    createddate  timestamp  DEFAULT CURRENT_TIMESTAMP  not null ,
    description  varchar(1024) null,
    modifieddate timestamp  DEFAULT CURRENT_TIMESTAMP  not null ,
    name         varchar(512)  not null
);

CREATE TABLE IF NOT EXISTS sandboxtype
(
    id            int           not null
        primary key,
    createddate   timestamp  DEFAULT CURRENT_TIMESTAMP  not null ,
    description   varchar(1024) null,
    modifieddate  timestamp  DEFAULT CURRENT_TIMESTAMP  not null ,
    name          varchar(512)  not null,
    contextmodel  bit           not null,
    gmotablename  varchar(50)   null,
    definition_id int           null,
    constraint fk_sandbox_type_def
        foreign key (definition_id) references sandboxtypesdefinition (id)
);

CREATE TABLE IF NOT EXISTS sandboxattribute
(
    id                 int           not null
        primary key,
    createddate        timestamp  DEFAULT CURRENT_TIMESTAMP  not null ,
    description        varchar(1024) null,
    modifieddate       timestamp  DEFAULT CURRENT_TIMESTAMP  not null ,
    name               varchar(512)  not null,
    smartparamtypename varchar(512)  null,
    typedefinedby      varchar(255)  null,
    gmocolumnname      varchar(40)   null,
    gmopersistence     varchar(10)   null,
    multivalue         bit           not null,
    sandboxtype_id     int           null,
    type_id            int           null,
    constraint fk_satt_stype
        foreign key (type_id) references sandboxtype (id),
    constraint fk_sattr_type_stype
        foreign key (sandboxtype_id) references sandboxtype (id)
);

CREATE TABLE IF NOT EXISTS seq_config_params
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_domain_element
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_domain_element_attribute
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_domain_element_ea
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_domain_reference
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_domain_type
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_domain_type_attribute
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_domain_type_collection
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_external_storage
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_function_formal_argument
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_functionimpl
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_hyp_function
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_import_history
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_import_history_element
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_jwt_token
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_license
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_login_event
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_parameter
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_parameter_entry
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_parameter_filter
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_parameter_level
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_region
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_region_version
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_region_version_schedule
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_reset_password_token
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_sandbox_attribute
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_sandbox_type
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_sandbox_types_definition
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_simulation_parameters
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_system_right_jpa
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_system_role_jpa
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_system_user_jpa
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_system_user_preference_jpa
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_tag
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_test_case_bundle
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_test_case_package
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_user_region_version
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_work_session
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_work_session_action
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_work_session_data
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_work_session_element
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS seq_work_session_element_group
(
    next_val bigint not null
);

CREATE TABLE IF NOT EXISTS simulationparameters
(
    id           int          not null
        primary key,
    content      longtext     null,
    createddate  timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    modifiedby   varchar(521) not null,
    modifieddate timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    name         varchar(512) not null
);

CREATE TABLE IF NOT EXISTS suggestedvalueconfiguration
(
    id                    int          not null
        primary key,
    valueprovidername     varchar(512) not null,
    valueprovidersettings longtext     null
);

CREATE TABLE IF NOT EXISTS systemrightjpa
(
    id          int          not null
        primary key,
    code        varchar(255) not null,
    createdate  timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    description varchar(255) null,
    constraint uk_systemrightjpa_code
        unique (code)
);

CREATE TABLE IF NOT EXISTS systemrolejpa
(
    id          int          not null
        primary key,
    code        varchar(100) null,
    createdate  timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    description varchar(255) null,
    constraint uk_systemrolejpa_code
        unique (code)
);

CREATE TABLE IF NOT EXISTS systemrolejpa_systemrightjpa
(
    roles_id  int not null,
    rights_id int not null,
    primary key (roles_id, rights_id),
    constraint fk_right_role
        foreign key (roles_id) references systemrolejpa (id),
    constraint fk_role_right
        foreign key (rights_id) references systemrightjpa (id)
);

CREATE TABLE IF NOT EXISTS systemuserjpa
(
    id              int                           not null
        primary key,
    createdate      timestamp                     not null,
    email           varchar(255)                  null,
    firstname       varchar(255)                  not null,
    lastname        varchar(255)                  not null,
    login           varchar(255)                  not null,
    PASSWORD        varchar(255)                  null,
    status          varchar(255)                  null,
    lastupdate      timestamp(3)                  null,
    password_status varchar(50) default 'PRE_SET' not null,
    constraint uk_systemuserjpa_email
        unique (email),
    constraint uk_systemuserjpa_login
        unique (login)
);

CREATE TABLE IF NOT EXISTS loginevent
(
    id        int       not null
        primary key,
    eventdate timestamp null,
    result    int       null,
    user_id   int       null,
    constraint fk_event_user
        foreign key (user_id) references systemuserjpa (id)
);

CREATE TABLE IF NOT EXISTS parameterfilter
(
    id          int          not null
        primary key,
    description varchar(255) null,
    filter      longtext     not null,
    global      bit          not null,
    name        varchar(32)  not null,
    owner_id    int          not null,
    constraint fk_pfilter_user
        foreign key (owner_id) references systemuserjpa (id)
);

CREATE TABLE IF NOT EXISTS systemuserjpa_systemrolejpa
(
    users_id int not null,
    roles_id int not null,
    primary key (users_id, roles_id),
    constraint fk_role_user
        foreign key (users_id) references systemuserjpa (id),
    constraint fk_user_role
        foreign key (roles_id) references systemrolejpa (id)
);

CREATE TABLE IF NOT EXISTS systemuserpreferencejpa
(
    id       int          not null
        primary key,
    key_name varchar(255) null,
    value    varchar(255) null,
    user_id  int          null,
    constraint fk_pref_user
        foreign key (user_id) references systemuserjpa (id)
);

CREATE TABLE IF NOT EXISTS testcasepackage
(
    id           int          not null
        primary key,
    createddate  timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    modifiedby   varchar(512) not null,
    modifieddate timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    name         varchar(512) not null
);

CREATE TABLE IF NOT EXISTS testcasebundle
(
    id           int          not null
        primary key,
    createddate  timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    modifiedby   varchar(512) not null,
    modifieddate timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    name         varchar(512) not null,
    content      longtext     null,
    packageid    int          null,
    packageidx   int          null,
    constraint fk_budle_package
        foreign key (packageid) references testcasepackage (id)
);

CREATE TABLE IF NOT EXISTS userregionversion
(
    id               int          not null
        primary key,
    username         varchar(255) not null,
    regionversion_id int          not null,
    constraint fk_urv_region
        foreign key (regionversion_id) references regionversion (id)
);

CREATE TABLE IF NOT EXISTS worksession
(
    id            int          not null
        primary key,
    description   varchar(512) null,
    enddate       timestamp    null,
    startdate     timestamp DEFAULT CURRENT_TIMESTAMP  not null ,
    status        varchar(255) null,
    username      varchar(512) null,
    lastupdate    timestamp(3) null,
    expiryDate    timestamp(3) null,
    remoteSession bit          not null
);

create index ix_ws_lastupdate
    on worksession (lastupdate);

create index ix_ws_user_stat
    on worksession (username, status);

CREATE TABLE IF NOT EXISTS worksessionaction
(
    id             int         not null
        primary key,
    worksession_id int         not null,
    object_id      int         null,
    type           varchar(50) not null
);

CREATE TABLE IF NOT EXISTS worksessiondata
(
    id               int not null
        primary key,
    archive          bit not null,
    copyfromid       int null,
    head             bit not null,
    worksessionid    int null,
    regionversion_id int null,
    constraint fk_wdata_region
        foreign key (regionversion_id) references regionversion (id)
);

CREATE TABLE IF NOT EXISTS worksessionelement
(
    id                 int          not null
        primary key,
    baseelementid      int          null,
    code               varchar(255) null,
    createdate         timestamp(3) null,
    elementid          int          null,
    groupid            int          null,
    operation          varchar(255) null,
    operationdate      timestamp(3) null,
    type               varchar(255) null,
    regionversionid_id int          null,
    worksession_id     int          not null,
    constraint fk_element_worksession
        foreign key (worksession_id) references worksession (id),
    constraint fk_welement_region
        foreign key (regionversionid_id) references regionversion (id)
);

create index element_by_group
    on worksessionelement (groupid);

create index ix_wse_fk_ws
    on worksessionelement (worksession_id);
