/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.domain;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.core.ext.ParamValueProxyFactory;
import io.higson.runtime.decoder.CascadeDecoder;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.model.DomainAttribute;
import io.higson.runtime.model.Type;

public class AttributeValueResolver {
    private final HigsonEngine engine;
    private final CascadeDecoder decoder;

    public AttributeValueResolver(HigsonEngine engine) {
        this.engine = engine;
        this.decoder = new CascadeDecoder(engine);
    }

    public ParamValue getValue(DomainAttribute attr, ParamContext ctx, Object ... args) {
        Type type = attr.getRawType();
        String text = attr.getRawValue();
        return ParamValueProxyFactory.get(switch (type) {
            case Type.LITERAL -> text;
            case Type.PARAMETER -> this.processParameter(ctx, text);
            case Type.FUNCTION -> this.processFunction(ctx, text, args);
            default -> throw new HigsonRuntimeException("unsupported type: " + type);
        });
    }

    private Object processFunction(ParamContext ctx, String value, Object ... args) {
        if (this.isSimpleFunction(value)) {
            return this.engine.call(value, ctx, args);
        }
        return this.decoder.cascadeCall(value, ctx);
    }

    private Object processParameter(ParamContext ctx, String value) {
        if (this.isSimpleParameter(value)) {
            return this.engine.get(value, ctx);
        }
        return this.decoder.cascadeGetMultiValues(value, ctx);
    }

    private boolean isSimpleParameter(String value) {
        return !value.contains("[");
    }

    private boolean isSimpleFunction(String value) {
        return !value.contains("(") && !value.contains("[");
    }

    public String getDigest(Type type, String value) {
        return this.engine.getDigest(type, value);
    }
}

