/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.decoder;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.decoder.CascadeDecoder;
import io.higson.runtime.engine.core.decoder.ValueDecoder;
import io.higson.runtime.model.MpParameterEntry;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.model.ParameterLevel;

public class MpDecodingStrategy {
    private HigsonEngine engine;

    public MpDecodingStrategy(HigsonEngine engine) {
        this.engine = engine;
    }

    public ValueDecoder createCascadeDecoder() {
        return new CascadeDecoder(this.engine);
    }

    public void detectCascadingRefs(Parameter p, MpParameterEntry entry) {
        int inputCnt = p.getInputLevels();
        int levelCnt = p.getLevelCount();
        String[] cells = entry.getLevels();
        for (int i = inputCnt; i < levelCnt; ++i) {
            ParameterLevel out = p.getLevel(i);
            if (out.getValueDecoder() != null || !this.hasRef(cells[i], out)) continue;
            out.setValueDecoder(this.createCascadeDecoder());
        }
    }

    private boolean hasRef(String cell, ParameterLevel out) {
        if (cell != null) {
            if (this.isValueBlob(cell, out)) {
                return true;
            }
            if (this.isValueFunctionOrParameter(cell)) {
                return (cell = cell.trim()).startsWith("$f ") || cell.startsWith("$p ");
            }
        }
        return false;
    }

    private boolean isValueFunctionOrParameter(String cell) {
        return cell.length() > 3 && cell.indexOf(36) >= 0;
    }

    private boolean isValueBlob(String cell, ParameterLevel out) {
        return out.isExternal() && cell.indexOf(64) == 0;
    }

    public boolean hasEngineConfigured() {
        return this.engine != null;
    }

    public MpDecodingStrategy() {
    }

    public void setEngine(HigsonEngine engine) {
        this.engine = engine;
    }
}

