/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.annotated.initialization;

import io.higson.runtime.engine.annotated.PackageList;
import io.higson.runtime.engine.annotated.repository.MethodScanningRepository;
import io.higson.runtime.engine.annotated.scanner.MethodScanner;
import io.higson.runtime.engine.annotated.scanner.PackageMethodScanner;
import io.higson.runtime.engine.config.initialization.ComponentInitializer;
import io.higson.runtime.engine.config.initialization.ComponentInitializerRunner;

public class MethodScannerInitializer
implements ComponentInitializer {
    private final PackageList packagesToScan;
    private final MethodScanner methodScanner;

    public MethodScannerInitializer(MethodScanner methodScanner, PackageList packagesToScan) {
        this.packagesToScan = packagesToScan;
        this.methodScanner = methodScanner;
    }

    public MethodScannerInitializer(PackageList packagesToScan) {
        this(new PackageMethodScanner(packagesToScan), packagesToScan);
    }

    @Override
    public void initializeObject(Object configObject, ComponentInitializerRunner runner) {
        MethodScanningRepository repository = (MethodScanningRepository)configObject;
        repository.scanMethods(this.methodScanner);
    }

    @Override
    public boolean acceptsObject(Object configObject) {
        return MethodScanningRepository.class.isAssignableFrom(configObject.getClass());
    }

    public PackageList getPackageList() {
        return this.packagesToScan;
    }

    public String getDefaultPackage() {
        return this.packagesToScan.getDefaultPackage();
    }
}

