/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.annotated.repository;

import io.higson.runtime.engine.annotated.RepositoryObjectKey;
import io.higson.runtime.engine.annotated.annotations.ParamFunctionRepository;
import io.higson.runtime.engine.annotated.repository.TypeScanningRepository;
import io.higson.runtime.engine.annotated.scanner.TypeScanner;
import io.higson.runtime.engine.config.initialization.ComponentInitializerRunner;
import io.higson.runtime.engine.core.function.Function;
import io.higson.runtime.engine.core.function.FunctionCache;
import io.higson.runtime.engine.core.function.FunctionProvider;
import io.higson.runtime.engine.core.function.FunctionRepository;
import io.higson.runtime.engine.core.function.UnknownFunctionException;
import io.higson.runtime.engine.core.repository.MapRepository;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ScanningFunctionProvider
implements FunctionProvider,
TypeScanningRepository {
    private final MapRepository<FunctionRepository> innerRepository = new MapRepository(FunctionRepository.class, new TreeMap());
    private final FunctionCache functionCache;

    public ScanningFunctionProvider(FunctionCache functionCache) {
        this.functionCache = functionCache;
    }

    @Override
    public void scanAnnotations(TypeScanner scanner, ComponentInitializerRunner componentInitializerRunner) {
        Map repositories = scanner.scanTypes(ParamFunctionRepository.class);
        componentInitializerRunner.runInitializersOnList(repositories.values());
        this.innerRepository.registerAll(repositories);
    }

    @Override
    public void register(String type, int order, FunctionRepository repository) {
        RepositoryObjectKey objectKey = new RepositoryObjectKey(type, order);
        this.innerRepository.registerUnique(objectKey, repository);
    }

    @Override
    public Map<String, FunctionRepository> registeredItems() {
        return this.innerRepository.getItemsOrdered();
    }

    @Override
    public void registerAll(Map<String, FunctionRepository> items) {
        this.innerRepository.registerAllOrdered(items);
    }

    @Override
    public void registerWithKeys(Map<RepositoryObjectKey, FunctionRepository> objects) {
        this.innerRepository.registerAll(objects);
    }

    @Override
    public Function getFunction(String functionName) {
        Function function = this.functionCache.get(functionName);
        if (function == null) {
            function = this.searchForFunction(functionName);
            if (function == null) {
                throw new UnknownFunctionException(functionName);
            }
            this.functionCache.put(functionName, function);
        }
        return function;
    }

    private Function searchForFunction(String functionName) {
        FunctionRepository repository;
        Function function = null;
        Iterator<FunctionRepository> iterator = this.innerRepository.getItemsOrdered().values().iterator();
        while (iterator.hasNext() && (function = (repository = iterator.next()).loadFunction(functionName)) == null) {
        }
        return function;
    }

    @Override
    public FunctionCache getFunctionCache() {
        return this.functionCache;
    }
}

