/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.config;

import io.higson.runtime.core.PropertiesAware;
import io.higson.runtime.engine.config.ParamEngineConfig;
import io.higson.runtime.engine.config.initialization.BasicComponentInitializerRunner;
import io.higson.runtime.engine.config.initialization.ComponentInitializerRunner;
import io.higson.runtime.engine.config.pico.PicoContainerUtil;
import io.higson.runtime.engine.config.pico.PicoParamEngineRuntimeConfigBuilder;
import io.higson.runtime.engine.core.ParamEngine;
import io.higson.runtime.engine.core.SmartParamEngine;
import io.higson.runtime.engine.core.function.FunctionProvider;
import io.higson.runtime.engine.core.function.InvokerRepository;
import io.higson.runtime.engine.core.matcher.MatcherRepository;
import io.higson.runtime.engine.core.parameter.ParameterProvider;
import io.higson.runtime.engine.core.prepared.BasicParamPreparer;
import io.higson.runtime.engine.core.type.TypeRepository;
import io.higson.runtime.function.FunctionManager;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class ParamEngineFactory {
    public static ParamEngine paramEngine(ParamEngineConfig config) {
        return new ParamEngineFactory().createParamEngine(config);
    }

    public ParamEngine createParamEngine(@NotNull ParamEngineConfig config) {
        Objects.requireNonNull(config, "config cannot be null");
        ComponentInitializerRunner initializerRunner = this.prepareInitializerRunner(config);
        MutablePicoContainer picoContainer = PicoContainerUtil.createContainer();
        picoContainer.addComponent(SmartParamEngine.class);
        PicoContainerUtil.injectImplementations(picoContainer, config.getComponents());
        picoContainer.addComponent(new PicoParamEngineRuntimeConfigBuilder(picoContainer));
        ParamEngine engine = picoContainer.getComponent(ParamEngine.class);
        this.initializeRepositories(picoContainer, config, initializerRunner);
        this.initializeInterceptors(picoContainer, config);
        this.initializeProperties(picoContainer, config);
        this.initializeIdleChecker(picoContainer, config);
        initializerRunner.runInitializersOnList(picoContainer.getComponents());
        return engine;
    }

    private ComponentInitializerRunner prepareInitializerRunner(ParamEngineConfig config) {
        if (config.getInitializationRunner() == null) {
            BasicComponentInitializerRunner initializerRunner = new BasicComponentInitializerRunner();
            initializerRunner.registerInitializers(config.getComponentInitializers());
            config.setInitializationRunner(initializerRunner);
        }
        return config.getInitializationRunner();
    }

    private void initializeRepositories(PicoContainer container, ParamEngineConfig config, ComponentInitializerRunner initializerRunner) {
        initializerRunner.runInitializersOnList(config.getParameterRepositories());
        container.getComponent(ParameterProvider.class).registerAll(config.getParameterRepositories());
        initializerRunner.runInitializersOnList(config.getFunctionRepositories().values());
        container.getComponent(FunctionProvider.class).registerWithKeys(config.getFunctionRepositories());
        container.getComponent(InvokerRepository.class).registerAll(config.getFunctionInvokers());
        container.getComponent(TypeRepository.class).registerAll(config.getTypes());
        container.getComponent(MatcherRepository.class).registerAll(config.getMatchers());
    }

    private void initializeInterceptors(PicoContainer container, ParamEngineConfig config) {
        container.getComponent(FunctionManager.class).registerInterceptors(config.getFunctionInvocationInterceptors());
    }

    private void initializeProperties(PicoContainer container, ParamEngineConfig config) {
        for (PropertiesAware component : container.getComponents(PropertiesAware.class)) {
            component.setProperties(config.getProperties());
        }
    }

    private void initializeIdleChecker(PicoContainer container, ParamEngineConfig config) {
        container.getComponent(BasicParamPreparer.class).setIdleChecker(config.getIdleChecker());
    }
}

