/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.output;

import io.higson.runtime.engine.core.output.InvalidRowIndexException;
import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.util.Formatter;
import io.higson.runtime.engine.util.Printer;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class ParamValueImpl
implements ParamValue {
    private final MultiValue[] rows;
    private final Object metadata;

    public ParamValueImpl(MultiValue[] rows, Object metadata) {
        this.rows = Arrays.copyOf(rows, rows.length);
        this.metadata = metadata;
    }

    public ParamValueImpl(MultiValue ... rows) {
        this(rows, (Object)null);
    }

    @Override
    public MultiValue row(int rowNo) {
        if (rowNo >= 0 && rowNo < this.size()) {
            return this.rows[rowNo];
        }
        throw new InvalidRowIndexException(rowNo, this.rows);
    }

    @Override
    public MultiValue row() {
        return this.row(0);
    }

    @Override
    public List<MultiValue> rows() {
        return Arrays.asList(this.rows);
    }

    @Override
    public Iterator<MultiValue> iterator() {
        return this.rows().iterator();
    }

    @Override
    public ValueHolder getHolder(int rowNo, int colNo) {
        return this.row(rowNo).getHolder(colNo);
    }

    @Override
    public <T> T get(int rowNo, int colNo) {
        return this.row(rowNo).get(colNo);
    }

    @Override
    public <T> T get(int rowNo, int colNo, Class<T> clazz) {
        return this.row(rowNo).get(colNo, clazz);
    }

    @Override
    public ValueHolder getHolder(int rowNo, String name) {
        return this.row(rowNo).getHolder(name);
    }

    @Override
    public <T> T get(int rowNo, String name) {
        return this.row(rowNo).get(name);
    }

    @Override
    public <T> T get(int rowNo, String name, Class<T> clazz) {
        return this.row(rowNo).get(name, clazz);
    }

    @Override
    public ValueHolder getHolder(int colNo) {
        return this.row().getHolder(colNo);
    }

    @Override
    public <T> T get(int colNo) {
        return this.row().get(colNo);
    }

    @Override
    public <T> T get(int colNo, Class<T> clazz) {
        return this.row().get(colNo, clazz);
    }

    @Override
    public ValueHolder getHolder(String name) {
        return this.row().getHolder(name);
    }

    @Override
    public <T> T get(String name) {
        return this.row().get(name);
    }

    @Override
    public <T> T get(String name, Class<T> clazz) {
        return this.row().get(name, clazz);
    }

    @Override
    public String getString(String name) {
        return this.row().getString(name);
    }

    @Override
    public BigDecimal getBigDecimal(String name) {
        return this.row().getBigDecimal(name);
    }

    @Override
    public Date getDate(String name) {
        return this.row().getDate(name);
    }

    @Override
    public Date getDatetime(String name) {
        return this.row().getDatetime(name);
    }

    @Override
    public LocalDate getLocalDate(String name) {
        return this.row().getLocalDate(name);
    }

    @Override
    public LocalDateTime getLocalDatetime(String name) {
        return this.row().getLocalDatetime(name);
    }

    @Override
    public Integer getInteger(String name) {
        return this.row().getInteger(name);
    }

    @Override
    public Long getLong(String name) {
        return this.row().getLong(name);
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.row().getBoolean(name);
    }

    @Override
    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass) {
        return this.row().getEnum(name, enumClass);
    }

    @Override
    public <T extends Enum<T>> Set<T> getEnumSet(String name, Class<T> enumClass) {
        HashSet<T> enumSet = new HashSet<T>();
        for (MultiValue row : this.rows) {
            enumSet.add(row.getEnum(name, enumClass));
        }
        return enumSet;
    }

    @Override
    public ValueHolder getHolder() {
        return this.row().getHolder(0);
    }

    @Override
    public <T> T get() {
        return this.row().get(0);
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return this.row().get(0, clazz);
    }

    @Override
    public String getString() {
        return this.row().getString(0);
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.row().getBigDecimal(0);
    }

    @Override
    public Date getDate() {
        return this.row().getDate(0);
    }

    @Override
    public Date getDatetime() {
        return this.row().getDatetime(0);
    }

    @Override
    public LocalDate getLocalDate() {
        return this.row().getLocalDate(0);
    }

    @Override
    public LocalDateTime getLocalDatetime() {
        return this.row().getLocalDatetime(0);
    }

    @Override
    public Integer getInteger() {
        return this.row().getInteger(0);
    }

    @Override
    public Long getLong() {
        return this.row().getLong(0);
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> enumClass) {
        return this.row().getEnum(0, enumClass);
    }

    @Override
    public <T extends Enum<T>> Set<T> getEnumSet(Class<T> enumClass) {
        HashSet<T> enumSet = new HashSet<T>();
        for (MultiValue row : this.rows) {
            enumSet.add(row.getEnum(0, enumClass));
        }
        return enumSet;
    }

    @Override
    public int size() {
        return this.rows != null ? this.rows.length : 0;
    }

    @Override
    public Object getMetadata() {
        return this.metadata;
    }

    @Override
    public Boolean getBoolean() {
        return this.row().getBoolean(0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isBlank() {
        for (MultiValue row : this.rows) {
            if (row.isBlank()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Stream<MultiValue> stream() {
        return Stream.of(this.rows);
    }

    public String toString() {
        return Printer.print(Arrays.asList(this.rows), "ParamValue", 0, new MultiValueInlineFormatter());
    }

    static final class MultiValueInlineFormatter
    implements Formatter {
        MultiValueInlineFormatter() {
        }

        @Override
        public String format(Object obj) {
            MultiValue mv = (MultiValue)obj;
            return mv.toStringInline();
        }
    }
}

