/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.datetime;

import io.higson.runtime.engine.core.type.AbstractValueHolder;
import io.higson.runtime.engine.types.date.DateTimeFormatterPool;
import io.higson.runtime.engine.types.datetime.LocalDateTimeType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class LocalDateTimeHolder
extends AbstractValueHolder {
    private final LocalDateTime localDateTime;

    @Override
    public LocalDateTime getValue() {
        return this.localDateTime;
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }

    @Override
    public LocalDate getLocalDate() {
        return this.localDateTime != null ? this.localDateTime.toLocalDate() : null;
    }

    @Override
    public Date getDate() {
        return this.localDateTime != null ? Date.from(this.localDateTime.atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    @Override
    public Date getDatetime() {
        return this.localDateTime != null ? Date.from(this.localDateTime.atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    @Override
    public Long getLong() {
        return this.localDateTime != null ? Long.valueOf(ZonedDateTime.of(this.localDateTime, ZoneId.systemDefault()).toInstant().toEpochMilli()) : null;
    }

    @Override
    public long longValue() {
        return this.localDateTime != null ? ZonedDateTime.of(this.localDateTime, ZoneId.systemDefault()).toInstant().toEpochMilli() : 0L;
    }

    @Override
    public String getString() {
        return this.getString(LocalDateTimeType.getDefaultOutputPattern());
    }

    public String getString(String pattern) {
        return this.localDateTime != null ? DateTimeFormatterPool.ofPattern(pattern).format(this.localDateTime) : null;
    }

    public LocalDateTimeHolder(LocalDateTime localDateTime) {
        this.localDateTime = localDateTime;
    }
}

