/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper;

import io.higson.runtime.helper.StrUtil;

public class SqlUtil {
    private SqlUtil() {
        throw new UnsupportedOperationException("util class");
    }

    public static String getPart(String sql, int maxlen) {
        sql = StrUtil.compactSpaces(sql);
        sql = sql.replace('\n', ' ').replace('\t', ' ');
        sql = sql.toLowerCase();
        maxlen = Math.max(maxlen, 10);
        if (sql.contains(".nextval")) {
            return SqlUtil.trunc(sql, maxlen);
        }
        if (sql.startsWith("delete")) {
            return SqlUtil.trunc(sql, maxlen);
        }
        if (sql.contains(" from")) {
            return "..." + SqlUtil.trunc(sql.substring(sql.lastIndexOf(" from") + 1), maxlen - 3);
        }
        return SqlUtil.trunc(sql, maxlen);
    }

    public static String trunc(String s, int maxlen) {
        return StrUtil.trunc(s, maxlen);
    }

    public static String printInline(String sql) {
        if (sql == null) {
            return null;
        }
        return StrUtil.compactSpaces(sql.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').toLowerCase());
    }
}

