/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper;

import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.bool.BooleanHolder;
import io.higson.runtime.engine.types.date.DateHolder;
import io.higson.runtime.engine.types.date.DateType;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.date.LocalDateType;
import io.higson.runtime.engine.types.datetime.DatetimeHolder;
import io.higson.runtime.engine.types.datetime.DatetimeType;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeType;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.types.integer.IntegerType;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.types.number.NumberType;
import io.higson.runtime.engine.types.string.StringHolder;
import io.higson.runtime.engine.types.string.StringType;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.helper.MathUtil;
import io.higson.runtime.type.BooleanType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Clob;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class TypeConverter {
    public static final String NUMBER_TYPE = "number";
    public static final String INTEGER_TYPE = "integer";
    public static final String STRING_TYPE = "string";
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String DATE_TYPE = "date";
    public static final String LOCALDATE_TYPE = "localdate";
    public static final String DATETIME_TYPE = "datetime";
    public static final String LOCALDATETIME_TYPE = "localdatetime";
    public static final String NULL_VALUE = "null";
    private static final int NUMBER_HOLDER_CUTOFF = 12;
    private static final Map<Class<? extends ValueHolder>, String> HOLDER_TO_TYPE;
    private static final Map<Class<? extends ValueHolder>, ValueHolder> HOLDER_TO_NULL;
    private static final TypeConverter instance;

    public NumberHolder toNumberHolder(Object obj) {
        if (obj instanceof NumberHolder) {
            return (NumberHolder)obj;
        }
        return new NumberHolder(this.getDecimal(obj));
    }

    public double getNumber(Object obj) {
        return this.toNumberHolder(obj).doubleValue();
    }

    public double getNumber(Object obj, int scale) {
        return this.getDecimal(obj, scale).doubleValue();
    }

    public BigDecimal getDecimal(Object obj) {
        NumberHolder holder = this.convert(obj, this.getNumberType());
        return MathUtil.round(holder.getBigDecimal(), 12);
    }

    public BigDecimal getDecimal(Object obj, int scale) {
        return this.getDecimal(obj).setScale(scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public IntegerHolder toIntegerHolder(Object obj) {
        if (obj instanceof IntegerHolder) {
            return (IntegerHolder)obj;
        }
        if (obj instanceof NumberHolder) {
            return new IntegerHolder(((NumberHolder)obj).getLong());
        }
        if (obj instanceof Number) {
            return new IntegerHolder(((Number)obj).longValue());
        }
        if (obj == null) {
            return new IntegerHolder(null);
        }
        return new IntegerHolder(this.toNumberHolder(obj).getLong());
    }

    public Integer getInteger(Object obj) {
        return this.toIntegerHolder(obj).getInteger();
    }

    public Long getLong(Object obj) {
        return this.toIntegerHolder(obj).getLong();
    }

    public DateHolder toDateHolder(Object obj) {
        if (obj instanceof DateHolder) {
            return (DateHolder)obj;
        }
        if (obj instanceof Number) {
            long time = ((Number)obj).longValue();
            return new DateHolder(new Date(time));
        }
        return this.convert(obj, this.getDateType());
    }

    public Date getDate(Object obj) {
        return this.toDateHolder(obj).getDate();
    }

    public LocalDateHolder toLocalDateHolder(Object obj) {
        if (obj instanceof LocalDateHolder) {
            return (LocalDateHolder)obj;
        }
        if (obj instanceof Number) {
            long time = ((Number)obj).longValue();
            return new LocalDateHolder(Instant.ofEpochMilli(time).atZone(ZoneId.systemDefault()).toLocalDate());
        }
        return this.convert(obj, this.getLocalDateType());
    }

    public LocalDate getLocalDate(Object obj) {
        return this.toLocalDateHolder(obj).getLocalDate();
    }

    public DatetimeHolder toDatetimeHolder(Object obj) {
        if (obj instanceof DatetimeHolder) {
            return (DatetimeHolder)obj;
        }
        if (obj instanceof DateHolder) {
            return new DatetimeHolder(((DateHolder)obj).getDate());
        }
        if (obj instanceof Number) {
            long time = ((Number)obj).longValue();
            return new DatetimeHolder(new Date(time));
        }
        return this.convert(obj, this.getDatetimeType());
    }

    public Date getDatetime(Object obj) {
        return this.toDatetimeHolder(obj).getDatetime();
    }

    public LocalDateTimeHolder toLocalDateTimeHolder(Object obj) {
        if (obj instanceof LocalDateTimeHolder) {
            return (LocalDateTimeHolder)obj;
        }
        if (obj instanceof LocalDateHolder) {
            return new LocalDateTimeHolder(((LocalDateHolder)obj).getLocalDateTime());
        }
        if (obj instanceof Number) {
            long time = ((Number)obj).longValue();
            return new LocalDateTimeHolder(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), TimeZone.getDefault().toZoneId()));
        }
        return this.convert(obj, this.getLocalDateTimeType());
    }

    public LocalDateTime getLocalDateTime(Object obj) {
        return this.toLocalDateTimeHolder(obj).getLocalDateTime();
    }

    public StringHolder toStringHolder(Object obj) {
        if (obj instanceof StringHolder) {
            return (StringHolder)obj;
        }
        return new StringHolder(this.toString(obj));
    }

    public String getString(Object obj) {
        return this.toString(obj);
    }

    private String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof ValueHolder) {
            return ((ValueHolder)obj).getString();
        }
        if (obj instanceof Date) {
            return this.getDateType().convert(obj).getString();
        }
        if (obj instanceof Clob) {
            return this.getClobAsString((Clob)obj);
        }
        return this.getStringType().convert(obj).getString();
    }

    private String getClobAsString(Clob clob) {
        try {
            return clob.getSubString(1L, (int)clob.length());
        }
        catch (SQLException e) {
            throw new HigsonRuntimeException("could not get string value from clob", e);
        }
    }

    public BooleanHolder toBooleanHolder(Object obj) {
        if (obj instanceof BooleanHolder) {
            return (BooleanHolder)obj;
        }
        return this.convert(obj, this.getBooleanType());
    }

    public boolean getBoolean(Object obj) {
        return this.toBooleanHolder(obj).booleanValue();
    }

    public ValueHolder toHolder(Object obj, String type) {
        return switch (type.toLowerCase()) {
            case STRING_TYPE -> this.toStringHolder(obj);
            case NUMBER_TYPE -> this.toNumberHolder(obj);
            case INTEGER_TYPE -> this.toIntegerHolder(obj);
            case BOOLEAN_TYPE -> this.toBooleanHolder(obj);
            case DATE_TYPE -> this.toDateHolder(obj);
            case DATETIME_TYPE -> this.toDatetimeHolder(obj);
            case LOCALDATE_TYPE -> this.toLocalDateHolder(obj);
            case LOCALDATETIME_TYPE -> this.toLocalDateTimeHolder(obj);
            default -> throw new HigsonRuntimeException("Unsupported conversion for type: [" + type + "]");
        };
    }

    public Object cast(Object obj, String type) {
        switch (type) {
            case "string": {
                return this.getString(obj);
            }
            case "integer": {
                return this.getLong(obj);
            }
            case "number": {
                return this.getDecimal(obj);
            }
            case "boolean": {
                return this.toBooleanHolder(obj).getBoolean();
            }
            case "date": {
                return this.getDate(obj);
            }
            case "datetime": {
                return this.getDatetime(obj);
            }
            case "localdate": {
                return this.getLocalDate(obj);
            }
            case "localdatetime": {
                return this.getLocalDateTime(obj);
            }
        }
        throw new HigsonRuntimeException("Type not supported: " + type);
    }

    public Type<? extends ValueHolder> getType(Class<? extends ValueHolder> holderClass) {
        String type = HOLDER_TO_TYPE.get(holderClass);
        return this.getType(type);
    }

    public Type<? extends ValueHolder> getType(String type) {
        switch (type) {
            case "string": {
                return this.getStringType();
            }
            case "integer": {
                return this.getIntegerType();
            }
            case "number": {
                return this.getNumberType();
            }
            case "boolean": {
                return this.getBooleanType();
            }
            case "date": {
                return this.getDateType();
            }
            case "datetime": {
                return this.getDatetimeType();
            }
            case "localdate": {
                return this.getLocalDateType();
            }
            case "localdatetime": {
                return this.getLocalDateTimeType();
            }
        }
        throw new HigsonRuntimeException("Type not supported: " + type);
    }

    public ValueHolder toHolder(Object obj, Class holderClass) {
        if (NULL_VALUE.equals(obj)) {
            return HOLDER_TO_NULL.get(holderClass);
        }
        return this.toHolder(obj, HOLDER_TO_TYPE.get(holderClass));
    }

    public StringType getStringType() {
        return HigsonContext.getStringType();
    }

    public NumberType getNumberType() {
        return HigsonContext.getNumberType();
    }

    public IntegerType getIntegerType() {
        return HigsonContext.getIntegerType();
    }

    public BooleanType getBooleanType() {
        return HigsonContext.getBooleanType();
    }

    public DateType getDateType() {
        return HigsonContext.getDateType();
    }

    public LocalDateType getLocalDateType() {
        return HigsonContext.getLocalDateType();
    }

    public DatetimeType getDatetimeType() {
        return HigsonContext.getDatetimeType();
    }

    public LocalDateTimeType getLocalDateTimeType() {
        return HigsonContext.getLocalDateTimeType();
    }

    private Object unwrap(Object obj) {
        if (obj instanceof ValueHolder) {
            return this.unwrap((ValueHolder)obj);
        }
        return obj;
    }

    private Object unwrap(ValueHolder holder) {
        return holder != null ? holder.getValue() : null;
    }

    private <H extends ValueHolder> H convert(Object obj, Type<H> type) {
        return type.convert(this.unwrap(obj));
    }

    public static TypeConverter getInstance() {
        return instance;
    }

    private TypeConverter() {
    }

    static {
        HashMap<Class<LocalDateTimeHolder>, Object> map = new HashMap<Class<LocalDateTimeHolder>, Object>();
        map.put(NumberHolder.class, NUMBER_TYPE);
        map.put(IntegerHolder.class, INTEGER_TYPE);
        map.put(StringHolder.class, STRING_TYPE);
        map.put(BooleanHolder.class, BOOLEAN_TYPE);
        map.put(DateHolder.class, DATE_TYPE);
        map.put(LocalDateHolder.class, LOCALDATE_TYPE);
        map.put(DatetimeHolder.class, DATETIME_TYPE);
        map.put(LocalDateTimeHolder.class, LOCALDATETIME_TYPE);
        HOLDER_TO_TYPE = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(NumberHolder.class, new NumberHolder(null));
        map.put(IntegerHolder.class, new IntegerHolder(null));
        map.put(StringHolder.class, new StringHolder(null));
        map.put(BooleanHolder.class, new BooleanHolder(null));
        map.put(DateHolder.class, new DateHolder(null));
        map.put(LocalDateHolder.class, new LocalDateHolder(null));
        map.put(LocalDateTimeHolder.class, new LocalDateTimeHolder(null));
        HOLDER_TO_NULL = Collections.unmodifiableMap(map);
        instance = new TypeConverter();
    }
}

