/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler;

public abstract class AbstractProfilerStat<T> {
    private T key;
    private long count;
    private long totalTime;
    private long minTime = Long.MAX_VALUE;
    private long maxTime = -1L;

    public AbstractProfilerStat(T key) {
        this.key = key;
    }

    public AbstractProfilerStat(AbstractProfilerStat<T> source) {
        this.key = source.getKey();
        this.count = source.getCount();
        this.totalTime = source.getTotalTime();
        this.minTime = source.getMinTime();
        this.maxTime = source.getMaxTime();
    }

    public void addTime(long t) {
        ++this.count;
        this.totalTime += t;
        if (t < this.minTime) {
            this.minTime = t;
        }
        if (t > this.maxTime) {
            this.maxTime = t;
        }
    }

    public double getAvgTime() {
        return (double)this.totalTime / (double)this.count;
    }

    public void subTotal(long amount) {
        this.totalTime -= amount;
    }

    public String toString() {
        return "[count=" + this.count + ", total=" + this.totalTime + ", avg=" + (double)this.totalTime / (double)this.count + ", min=" + this.minTime + ", max=" + this.maxTime + "]";
    }

    public T getKey() {
        return this.key;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }
}

