/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sync;

import io.higson.runtime.engine.core.function.FunctionCache;
import io.higson.runtime.engine.core.prepared.CacheEntry;
import io.higson.runtime.model.Function;
import io.higson.runtime.model.PropFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuntimeWatcherHelper {
    private static final Logger log = LoggerFactory.getLogger(RuntimeWatcherHelper.class);

    private RuntimeWatcherHelper() {
        throw new UnsupportedOperationException("util class");
    }

    public static void invalidateFunction(FunctionCache cache, int id) {
        log.debug("invalidating fc for fid: {}", (Object)id);
        boolean found = false;
        for (CacheEntry<io.higson.runtime.engine.core.function.Function> entry : cache.list()) {
            Function f = (Function)entry.getValue();
            if (f.getId() != id) continue;
            if (f instanceof PropFunction) break;
            String key = entry.getKey();
            cache.invalidate(key);
            log.debug("found and invalidated: [{}] -> {}", (Object)key, (Object)f);
            found = true;
            break;
        }
        if (!found) {
            log.debug("f not found in fc");
        }
    }
}

