/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sync;

import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.model.ElementType;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.Schedule;
import io.higson.runtime.model.region.ScheduleContainer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class ScheduleCache {
    private final Map<String, Schedule> parSchedules;
    private final Map<String, Schedule> funSchedules;
    private final Map<String, ScheduleContainer> profileToSchedulesMapping;
    private final int hash;
    private final Collection<RegionVersion> allVersions;
    private final Set<String> regionCodes;

    public ScheduleCache(Map<String, Schedule> parSchedules, Map<String, Schedule> funSchedules, Map<String, ScheduleContainer> profileToSchedulesMapping, int hash, Collection<RegionVersion> allVersions) {
        this.parSchedules = parSchedules;
        this.funSchedules = funSchedules;
        this.profileToSchedulesMapping = profileToSchedulesMapping;
        this.hash = hash;
        this.allVersions = allVersions;
        this.regionCodes = new TreeSet<String>();
        for (RegionVersion rv : allVersions) {
            this.regionCodes.add(rv.getRegion());
        }
    }

    public RegionVersion getActiveVersion(String regionCode) {
        for (RegionVersion rv : this.allVersions) {
            if (!rv.getRegion().equals(regionCode) || !rv.isActive()) continue;
            return rv;
        }
        return null;
    }

    public Optional<RegionVersion> getActiveVersion(String profileCode, String regionCode) {
        return this.allVersions.stream().filter(rv -> ScheduleCache.isEqualProfileRegionAndIsActive(profileCode, regionCode, rv)).findFirst();
    }

    public RegionVersion getVersionData(String region, String version) {
        return this.allVersions.stream().filter(rv -> rv.getRegion().equals(region) && rv.getNumber().equals(version)).findFirst().orElse(null);
    }

    public Optional<RegionVersion> getVersionData(String profileCode, String regionCode, String version) {
        return this.allVersions.stream().filter(rv -> ScheduleCache.isEqualProfileRegionAndVersion(profileCode, regionCode, version, rv)).findFirst();
    }

    private static boolean isEqualProfileRegionAndIsActive(String profile2, String region, RegionVersion regionVersion) {
        return Objects.equals(profile2, regionVersion.getProfileCode()) && Objects.equals(region, regionVersion.getRegion()) && regionVersion.isActive();
    }

    private static boolean isEqualProfileRegionAndVersion(String profile2, String region, String version, RegionVersion regionVersion) {
        return Objects.equals(profile2, regionVersion.getProfileCode()) && Objects.equals(region, regionVersion.getRegion()) && Objects.equals(version, regionVersion.getNumber());
    }

    public int getHash() {
        return this.hash;
    }

    public Schedule getParameterSchedule(String parameterCode) {
        return this.parSchedules.get(parameterCode);
    }

    public Schedule getFunctionSchedule(String functionCode) {
        return this.funSchedules.get(functionCode);
    }

    public Schedule getSchedule(String elementCode, ElementType type) {
        switch (type) {
            case PARAMETER: {
                return this.getParameterSchedule(elementCode);
            }
            case FUNCTION: {
                return this.getFunctionSchedule(elementCode);
            }
        }
        throw new HigsonRuntimeException("unexpected MpSchedule.ElementType: " + type);
    }

    public Optional<ScheduleContainer> getSchedules(String profileCode) {
        return Optional.ofNullable(this.profileToSchedulesMapping.get(profileCode));
    }

    public String toString() {
        return "ScheduleCache[hash=" + this.hash + ", #par=" + this.parSchedules.size() + ", #fun=" + this.funSchedules.size() + ", #sch=" + this.profileToSchedulesMapping.size() + ", #reg=" + this.regionCodes.size() + ", #ver=" + this.allVersions.size() + "]";
    }
}

