/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.util;

import java.util.ArrayList;

public abstract class EngineUtil {
    private EngineUtil() {
        throw new UnsupportedOperationException("util class");
    }

    public static boolean hasText(String text) {
        return text != null && !text.trim().isEmpty();
    }

    public static String[] split(String str, char delim, int maxTokens) {
        int max = maxTokens;
        ArrayList<String> result = new ArrayList<String>(max);
        if (max == 0) {
            max = -1;
        }
        int curr = -1;
        int prev = 0;
        do {
            if (++curr == str.length()) {
                result.add(str.substring(prev));
                break;
            }
            if (str.charAt(curr) != delim) continue;
            result.add(str.substring(prev, curr));
            --max;
            prev = curr + 1;
        } while (max != 0);
        return result.toArray(new String[0]);
    }

    public static String[] split(String str, char delim) {
        return EngineUtil.split(str, delim, 0);
    }

    public static String[] split2(String str, char delim) {
        String[] result = new String[]{"", ""};
        if (str != null) {
            int ix = str.indexOf(delim);
            if (ix >= 0) {
                result[0] = str.substring(0, ix);
                result[1] = str.substring(ix + 1);
            } else {
                result[0] = str;
            }
        }
        return result;
    }

    public static String trimAllWhitespace(String str) {
        if (!EngineUtil.hasText(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }
}

