/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.smartparam.engine.util.reflection.InnerReflectiveOperationException;

public final class ReflectionsHelper {
    private ReflectionsHelper() {
        throw new UnsupportedOperationException();
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException exception) {
            throw new InnerReflectiveOperationException(exception, String.format("Unable to load class %s using %s classloader.", className, classLoader));
        }
    }

    public static Set<Method> findMethodsAnnotatedWith(Class<? extends Annotation> annotationType, Class<?> parentClass) {
        HashSet<Method> annotatedMethods = new HashSet<Method>();
        for (Method method : parentClass.getMethods()) {
            if (!method.isAnnotationPresent(annotationType)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    public static Set<Field> findFieldsAnnotatedWith(Class<? extends Annotation> annotation, Class<?> parentClass) {
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : parentClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static void invokerSetter(Method setter, Object setterHostObject, Object argument) {
        try {
            setter.invoke(setterHostObject, argument);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException illegalAccessException) {
            ReflectionsHelper.throwExceptionForSetterInvocation(illegalAccessException, setter, setterHostObject, argument);
        }
    }

    private static void throwExceptionForSetterInvocation(Exception exception, Method setter, Object setterHostObject, Object argument) {
        throw new InnerReflectiveOperationException(exception, String.format("Could not invoke setter %s on object %s using %s as argument", setter.getName(), setterHostObject.getClass().getSimpleName(), argument.getClass().getSimpleName()));
    }
}

