/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.profiler.annotation;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Aspect
@Component
public class ExecutionTimeAspect {
    private static final Logger log = LoggerFactory.getLogger(ExecutionTimeAspect.class);

    @Pointcut(value="@annotation(pl.decerto.hyperon.common.profiler.annotation.LogExecutionTime)")
    private void annotationClass() {
    }

    @Pointcut(value="@within(pl.decerto.hyperon.common.profiler.annotation.LogExecutionTime)")
    private void withinClass() {
    }

    @Pointcut(value="execution(* *(..))")
    private void anyMethod() {
    }

    @Around(value="(annotationClass() || withinClass()) && anyMethod()")
    public Object logExecutionTime(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object;
        String className = joinPoint.getSignature().getDeclaringTypeName();
        String methodName = ((MethodSignature)joinPoint.getSignature()).getMethod().getName();
        StopWatch stopWatch = new StopWatch();
        try {
            log.trace("Before. ClassName: {}, MethodName: {}", (Object)className, (Object)methodName);
            stopWatch.start();
            Object result = joinPoint.proceed();
            stopWatch.stop();
            object = result;
        }
        catch (Throwable error) {
            try {
                log.trace("Throws unexpected error. ClassName: {}, MethodName: {}", (Object)className, (Object)methodName);
                throw error;
            }
            catch (Throwable throwable) {
                log.trace("After. ClassName: {}, MethodName: {}, TimeMs: {}", className, methodName, stopWatch.getTotalTimeMillis());
                throw throwable;
            }
        }
        log.trace("After. ClassName: {}, MethodName: {}, TimeMs: {}", className, methodName, stopWatch.getTotalTimeMillis());
        return object;
    }
}

