/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import io.higson.runtime.utils.Clock;
import io.higson.runtime.utils.SystemClock;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LoginAttemptHolder {
    static final int MAX_ATTEMPTS_LIMIT = 5;
    static final int MAX_COOL_DOWN_IN_SECONDS = 30;
    private final int maxAttempts;
    private final int failureCoolDown;
    private Map<String, LoginAttempts> loginToAttemptsMapping;
    private Clock expirationCheckClock;

    public LoginAttemptHolder(int maxAttempts, int failureCooldownInSeconds) {
        this(new SystemClock(), maxAttempts, failureCooldownInSeconds);
    }

    LoginAttemptHolder(Clock expirationCheckClock, int maxAttempts, int failureCooldownInSeconds) {
        this.expirationCheckClock = expirationCheckClock;
        this.maxAttempts = Math.min(maxAttempts, 5);
        this.failureCoolDown = Math.min(failureCooldownInSeconds, 30);
        this.loginToAttemptsMapping = new HashMap<String, LoginAttempts>();
    }

    public boolean reachedAttemptsLimit(String login) {
        if (this.loginToAttemptsMapping.containsKey(login)) {
            return this.checkExpirationDate(login);
        }
        return false;
    }

    private boolean checkExpirationDate(String login) {
        LoginAttempts loginAttempts = this.loginToAttemptsMapping.get(login);
        return loginAttempts.expireOn != null && loginAttempts.expireOn.after(this.getCurrentDate());
    }

    private Date getCurrentDate() {
        return new Date(this.expirationCheckClock.getTime());
    }

    public void incrementAttempt(String login) {
        if (!this.loginToAttemptsMapping.containsKey(login)) {
            this.loginToAttemptsMapping.put(login, new LoginAttempts());
        }
        this.loginToAttemptsMapping.get(login).increment();
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public int getFailureCoolDown() {
        return this.failureCoolDown;
    }

    public void reset(String login) {
        this.loginToAttemptsMapping.remove(login);
    }

    private class LoginAttempts {
        private int loginCounter;
        private Date expireOn;

        private LoginAttempts() {
        }

        void increment() {
            ++this.loginCounter;
            if (this.loginCounter == LoginAttemptHolder.this.maxAttempts) {
                this.setExpireDate();
                this.resetCounter();
            } else {
                this.expireOn = null;
            }
        }

        private void resetCounter() {
            this.loginCounter = 0;
        }

        private void setExpireDate() {
            Calendar cal = Calendar.getInstance();
            cal.add(13, LoginAttemptHolder.this.failureCoolDown);
            this.expireOn = cal.getTime();
        }
    }
}

