/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.dao;

import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import pl.decerto.hyperon.common.security.domain.JwtToken;
import pl.decerto.hyperon.common.security.domain.TokenType;

public interface JwtTokenDao
extends JpaRepository<JwtToken, Integer> {
    @Query(value="select jt from JwtToken jt where jt.user.id = :id and jt.tokenType = 'RUNTIME_REST_TOKEN'")
    public List<JwtToken> findRuntimeRestTokens(@Param(value="id") int var1);

    @Query(value="select jt from JwtToken jt where jt.user.id = :id and jt.tokenType = 'REFRESH_TOKEN'")
    public List<JwtToken> findRefreshToken(@Param(value="id") int var1);

    public List<JwtToken> findByTokenType(TokenType var1);

    public JwtToken findByTokenAndTokenType(String var1, TokenType var2);

    public void deleteJwtTokensByTokenInAndTokenType(List<String> var1, TokenType var2);

    @Modifying
    @Query(value="delete from JwtToken jt where jt.expirationDate < current_timestamp and jt.tokenType = 'REFRESH_TOKEN'")
    public void deleteExpiredRefreshTokens();
}

