/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.dao;

import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.domain.UserStatus;

public interface UserManagementDao
extends JpaRepository<SystemUserJPA, Integer> {
    public List<SystemUserJPA> findAll();

    public SystemUserJPA findByLogin(String var1);

    @Query(value="select su from SystemUserJPA su where LOWER(su.login) = :login")
    public Optional<SystemUserJPA> findByLoginWithIgnoreCase(@Param(value="login") String var1);

    @Query(value="select su from SystemUserJPA su where LOWER(su.email) = :email")
    public SystemUserJPA findByEmail(@Param(value="email") String var1);

    @Query(value="select login from SystemUserJPA where status = :status ")
    public List<String> getLogins(@Param(value="status") UserStatus var1);

    @Modifying
    @Query(value="update SystemUserJPA us set lastUpdate = CURRENT_TIMESTAMP where exists (select ro from us.roles ro where ro.id in (:roles))")
    public void updateLastUpdateViaRoles(@Param(value="roles") List<Integer> var1);

    @Modifying
    @Query(value="update SystemUserJPA us set us.password = :password where us.id = :id")
    public void updatePassword(@Param(value="password") String var1, @Param(value="id") int var2);
}

