/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.mapper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.domain.SystemRightJPA;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;
import pl.decerto.hyperon.common.security.dto.SystemRightDto;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.mapper.SystemRightMapper;
import pl.decerto.hyperon.common.security.mapper.SystemRoleMapper;

@Component
public class SystemRightMapperImpl
implements SystemRightMapper {
    @Autowired
    private SystemRoleMapper systemRoleMapper;

    @Override
    public List<SystemRightDto> toDto(List<SystemRightJPA> model) {
        if (model == null) {
            return null;
        }
        ArrayList<SystemRightDto> list = new ArrayList<SystemRightDto>(model.size());
        for (SystemRightJPA systemRightJPA : model) {
            list.add(this.toDto(systemRightJPA));
        }
        return list;
    }

    @Override
    public SystemRightDto toDto(SystemRightJPA model) {
        if (model == null) {
            return null;
        }
        SystemRightDto systemRightDto = new SystemRightDto();
        systemRightDto.setId(model.getId());
        systemRightDto.setCode(model.getCode());
        systemRightDto.setDescription(model.getDescription());
        systemRightDto.setCreateDate(model.getCreateDate());
        systemRightDto.setRoles(this.systemRoleJPASetToSystemRoleSet(model.getRoles()));
        return systemRightDto;
    }

    @Override
    public SystemRightJPA toEntity(SystemRightDto dto) {
        if (dto == null) {
            return null;
        }
        SystemRightJPA systemRightJPA = new SystemRightJPA();
        if (dto.getId() != null) {
            systemRightJPA.setId(dto.getId());
        }
        systemRightJPA.setCode(dto.getCode());
        systemRightJPA.setDescription(dto.getDescription());
        systemRightJPA.setCreateDate(dto.getCreateDate());
        return systemRightJPA;
    }

    protected Set<SystemRole> systemRoleJPASetToSystemRoleSet(Set<SystemRoleJPA> set) {
        if (set == null) {
            return null;
        }
        HashSet<SystemRole> set1 = new HashSet<SystemRole>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SystemRoleJPA systemRoleJPA : set) {
            set1.add(this.systemRoleMapper.toDto(systemRoleJPA));
        }
        return set1;
    }
}

