/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.resources;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Optional;

public class ResourceUtils {
    private ResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static InputStream getInputStream(String resourceFilename) {
        return ResourceUtils.class.getClassLoader().getResourceAsStream(resourceFilename);
    }

    public static Optional<URL> getResource(String resourceFileName) {
        return Optional.ofNullable(ResourceUtils.class.getClassLoader().getResource(resourceFileName));
    }

    public static Reader getReader(String resourceFilename) {
        return new InputStreamReader(ResourceUtils.getInputStream(resourceFilename));
    }

    public static BufferedReader getBufferedReader(String resourceFilename) {
        return new BufferedReader(ResourceUtils.getReader(resourceFilename));
    }

    public static BufferedReader getBufferedReader(String resourceFilename, int bufferSize) {
        return new BufferedReader(ResourceUtils.getReader(resourceFilename), bufferSize);
    }
}

